package jibe.tools.testing.mock.smtp.action;

import jibe.tools.testing.mock.smtp.MailMessage;
import jibe.tools.testing.mock.smtp.MailStore;
import jibe.tools.testing.mock.smtp.Response;
import jibe.tools.testing.mock.smtp.SmtpState;

public class Ehlo implements Action {

    public String toString() {
        return "EHLO";
    }

    public Response response(SmtpState smtpState, MailStore mailStore, MailMessage currentMessage) {
        if (SmtpState.GREET == smtpState) {
            return new Response(250, "OK", SmtpState.MAIL);
        } else {
            return new Response(503, "Bad sequence of commands: "
                    + this, smtpState);
        }
    }

}
