package jibe.tools.testing.mock.smtp.action;

import jibe.tools.testing.mock.smtp.MailMessage;
import jibe.tools.testing.mock.smtp.MailStore;
import jibe.tools.testing.mock.smtp.Response;
import jibe.tools.testing.mock.smtp.SmtpState;

public class DataEnd implements Action {

    @Override
    public String toString() {
        return ".";
    }

    public Response response(SmtpState smtpState, MailStore mailStore, MailMessage currentMessage) {
        if (SmtpState.DATA_HDR == smtpState || SmtpState.DATA_BODY == smtpState) {
            return new Response(250, "OK", SmtpState.QUIT);
        } else {
            return new Response(503, "Bad sequence of commands: " + this, smtpState);
        }
    }

}
