package jibe.tools.testing.mock.smtp.action;

import jibe.tools.testing.mock.smtp.MailMessage;
import jibe.tools.testing.mock.smtp.MailStore;
import jibe.tools.testing.mock.smtp.Response;
import jibe.tools.testing.mock.smtp.SmtpState;

public class Connect implements Action {

    public String toString() {
        return "Connect";
    }

    public Response response(SmtpState smtpState, MailStore mailStore, MailMessage currentMessage) {
        if (SmtpState.CONNECT == smtpState) {
            return new Response(220,
                    "localhost Dumbster SMTP service ready", SmtpState.GREET);
        } else {
            return new Response(503, "Bad sequence of commands: " + this,
                    smtpState);
        }
    }

}
