package jibe.tools.testing.mock.smtp.action;

import jibe.tools.testing.mock.smtp.MailMessage;
import jibe.tools.testing.mock.smtp.MailStore;
import jibe.tools.testing.mock.smtp.Response;
import jibe.tools.testing.mock.smtp.SmtpState;

public class BlankLine implements Action {

    @Override
    public String toString() {
        return "Blank line";
    }

    public Response response(SmtpState smtpState, MailStore mailStore, MailMessage currentMessage) {
        if (SmtpState.DATA_HDR == smtpState) {
            return new Response(-1, "", SmtpState.DATA_BODY);
        } else if (SmtpState.DATA_BODY == smtpState) {
            return new Response(-1, "", smtpState);
        } else {
            return new Response(503,
                    "Bad sequence of commands: " + this, smtpState);
        }
    }

}
