package jibe.tools.testing.bdd.executions.web.assertions;

import jibe.tools.bdd.api.Assertion;
import jibe.tools.bdd.api.ExecutionContext;
import jibe.tools.testing.bdd.executions.web.AbstractWebExecution;

/**
 *
 */
@SuppressWarnings("unused")
public class CurrentUrlEndsWith extends AbstractWebExecution<Boolean> implements Assertion {
    private final String endsWith;
    private String currentUrl;

    public CurrentUrlEndsWith(String endsWith) {
        this.endsWith = endsWith;
    }

    @Override
    public Boolean execute(ExecutionContext ctx) {
        currentUrl = getFluentWebDriver(ctx).url().toString();
        return currentUrl.endsWith(endsWith);
    }
}
