package jibe.tools.testing.bdd.executions.web;

import com.google.common.base.Throwables;
import jibe.tools.bdd.api.ExecutionContext;

import java.net.MalformedURLException;
import java.net.URL;

/**
 *
 */
@SuppressWarnings("unused")
public class WebGotoPage extends AbstractWebExecution {
    private final String url;

    public WebGotoPage(String url) {
        this.url = url;
    }

    @Override
    public URL execute(ExecutionContext ctx) {
        try {
            URL gotoURL = new URL(url);
            getWebDriver(ctx).get(gotoURL.toExternalForm());
            return gotoURL;
        } catch (MalformedURLException e) {
            throw Throwables.propagate(e);
        }
    }
}
