package jibe.tools.testing.bdd.executions.web;

import com.google.common.base.Throwables;
import jibe.tools.bdd.api.AbstractExecution;
import jibe.tools.bdd.api.ExecutionContext;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;

import java.net.URL;

/**
 *
 */
@SuppressWarnings("unused")
public class CreateDynamicWebServiceClient<T> extends AbstractExecution<T> {
    private final URL wsdlLocation;
    private final Class<T> serviceClass;
    private T serviceClient;

    public CreateDynamicWebServiceClient(URL wsdlLocation, Class<T> serviceClass) {
        this.wsdlLocation = wsdlLocation;
        this.serviceClass = serviceClass;
    }

    @Override
    public T execute(ExecutionContext ctx) {
        if (serviceClient == null) {
            try {
                Client dynamicClient = JaxWsDynamicClientFactory.newInstance().createClient(wsdlLocation);
                serviceClient = ServiceClientProxy.newInstance(dynamicClient, serviceClass);

            } catch (Exception e) {
                throw Throwables.propagate(e);
            }
        }
        return serviceClient;
    }
}
