package jibe.tools.testing.bdd.executions.smtp;

import jibe.tools.bdd.api.AbstractExecution;
import jibe.tools.bdd.api.ExecutionContext;
import jibe.tools.bdd.api.ExecutionContextKeyValue;
import jibe.tools.testing.mock.smtp.SmtpServer;

import java.util.Set;

/**
 *
 */
public class StopSmtpServer extends AbstractExecution<SmtpServer> {

    @Override
    public SmtpServer execute(ExecutionContext ctx) {
        Set<ExecutionContextKeyValue<SmtpServer>> foundSmtpServer = ctx.findByType(SmtpServer.class);
        if (foundSmtpServer.isEmpty()) {
            return null;
        }
        SmtpServer smtpServer = foundSmtpServer.iterator().next().getValue();
        smtpServer.stop();
        return smtpServer;
    }
}
