/*
 * Decompiled with CFR 0.152.
 */
package jibe.tools.fsm.core;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import jibe.tools.fsm.annotations.Action;
import jibe.tools.fsm.annotations.StartState;
import jibe.tools.fsm.annotations.State;
import jibe.tools.fsm.annotations.StateMachine;
import jibe.tools.fsm.annotations.TimerEvent;
import jibe.tools.fsm.annotations.Transition;
import jibe.tools.fsm.annotations.TransitionOnTimeout;
import jibe.tools.fsm.api.ActionType;
import jibe.tools.fsm.api.Engine;
import jibe.tools.fsm.core.TransitionOnTimeoutEvent;
import org.reflections.Configuration;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.scanners.FieldAnnotationsScanner;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.MethodParameterScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(EngineHelper.class);
    private final Engine engine;
    private final Object fsm;
    private final Reflections reflections;
    private final HashMap<Class<?>, TypeDefinition> typeMap = new HashMap();

    EngineHelper(Engine engine) {
        this.engine = engine;
        this.fsm = engine.getFsm();
        this.reflections = this.setupReflections(engine.getConfiguration().getClassLoader());
        try {
            this.scanStates();
            this.scanTimers();
            this.scanTimeouts();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    Set<Class<?>> getTimerEvents() {
        Iterable filter = Iterables.filter((Iterable)Iterables.filter(this.typeMap.values(), this.withType(TypeDefinition.Type.TIMER_EVENT)), this.annotationMatchingMyFsm(TimerEvent.class));
        Iterable transform = Iterables.transform((Iterable)filter, this.toClass());
        return Sets.newHashSet((Iterable)transform);
    }

    Set<TransitionOnTimeoutEvent> getTimeoutTransitions(Class<?> stateClass) {
        return this.typeMap.get(stateClass).timeoutEvents;
    }

    private Predicate<TypeDefinition> annotationMatchingMyFsm(final Class<? extends Annotation> annotationClass) {
        return new Predicate<TypeDefinition>(){

            public boolean apply(@Nullable TypeDefinition input) {
                String fsmName = EngineHelper.this.getFsmNameFromAnnotation(input.cls, annotationClass);
                return Strings.isNullOrEmpty((String)fsmName) || EngineHelper.this.getFsmName(EngineHelper.this.fsm.getClass()).equals(fsmName);
            }
        };
    }

    Optional<Class<?>> findStateClass(Class<?> stateClass) {
        HashSet states = Sets.newHashSet((Iterable)Iterables.transform((Iterable)Iterables.filter(this.typeMap.values(), this.withTypeAndClass(TypeDefinition.Type.STATE, stateClass)), this.toClass()));
        if (states.iterator().hasNext()) {
            return Optional.of(states.iterator().next());
        }
        states = Sets.newHashSet((Iterable)Iterables.transform((Iterable)Iterables.filter(this.typeMap.values(), this.withTypeAndClass(TypeDefinition.Type.START_STATE, stateClass)), this.toClass()));
        if (states.iterator().hasNext()) {
            return Optional.of(states.iterator().next());
        }
        return Optional.absent();
    }

    Optional<Set<Class<?>>> findStartState() {
        HashSet startStateClasses = Sets.newHashSet((Iterable)Iterables.transform((Iterable)Iterables.filter(this.typeMap.values(), this.withType(TypeDefinition.Type.START_STATE)), this.toClass()));
        if (startStateClasses.isEmpty()) {
            return Optional.absent();
        }
        if (startStateClasses.size() == 1) {
            Class startStateClass = (Class)startStateClasses.iterator().next();
            String fsmName = this.getFsmNameFromAnnotation(startStateClass, StartState.class);
            if (Strings.isNullOrEmpty((String)fsmName) || this.getFsmName(this.fsm.getClass()).equals(fsmName)) {
                return Optional.of((Object)Sets.newHashSet((Object[])new Class[]{startStateClass}));
            }
            return Optional.absent();
        }
        HashSet filtered = Sets.newHashSet((Iterable)Iterables.filter((Iterable)startStateClasses, (Predicate)new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return EngineHelper.this.getFsmName(EngineHelper.this.fsm.getClass()).equals(EngineHelper.this.getFsmNameFromAnnotation(input, StartState.class)) || input.getClass().getDeclaringClass().equals(EngineHelper.this.fsm.getClass());
            }
        }));
        if (filtered.isEmpty()) {
            return Optional.absent();
        }
        if (filtered.size() == 1) {
            return Optional.of((Object)Sets.newHashSet((Object[])new Class[]{(Class)filtered.iterator().next()}));
        }
        return Optional.of((Object)filtered);
    }

    private String getFsmNameFromAnnotation(Class<?> input, Class<? extends Annotation> annotationClass) {
        if (annotationClass.equals(StartState.class)) {
            StartState annotation = (StartState)input.getAnnotation(annotationClass);
            if (annotation == null) {
                throw new RuntimeException("shouldn't input: " + input + ", have annotation: " + annotationClass);
            }
            return annotation.fsm();
        }
        if (annotationClass.equals(State.class)) {
            State annotation = (State)input.getAnnotation(annotationClass);
            if (annotation == null) {
                throw new RuntimeException("shouldn't input: " + input + ", have annotation: " + annotationClass);
            }
            return annotation.fsm();
        }
        if (annotationClass.equals(TimerEvent.class)) {
            TimerEvent annotation = (TimerEvent)input.getAnnotation(annotationClass);
            if (annotation == null) {
                throw new RuntimeException("shouldn't input: " + input + ", have annotation: " + annotationClass);
            }
            return annotation.fsm();
        }
        throw new RuntimeException("don't know: " + annotationClass);
    }

    private void scanTimers() throws IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException {
        for (Class c : this.getAnnotatedWith(Class.class, TimerEvent.class)) {
            this.typeMap.put(c, new TypeDefinition(c, TimerEvent.class));
        }
    }

    private void scanTimeouts() throws IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException {
        for (Method m : this.getAnnotatedWith(Method.class, TransitionOnTimeout.class)) {
            if (!this.typeMap.containsKey(m.getReturnType())) {
                LOGGER.warn("timeout-annotated method: " + m + " does not transit to any known state");
                continue;
            }
            if (!this.typeMap.containsKey(m.getDeclaringClass())) {
                LOGGER.warn("timeout-annotated method: " + m + " is not declared in any known state");
                continue;
            }
            TypeDefinition typeDefinition = this.typeMap.get(m.getDeclaringClass());
            typeDefinition.addTimeout(new TransitionOnTimeoutEvent(m));
        }
    }

    private void scanStates() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (!this.typeMap.isEmpty()) {
            throw new IllegalStateException("already scanned....");
        }
        for (Class stateAnnotation : Sets.newHashSet((Object[])new Class[]{StartState.class, State.class})) {
            for (Class c : this.getAnnotatedWith(Class.class, stateAnnotation)) {
                LOGGER.debug("scanned state: " + c);
                this.typeMap.put(c, new TypeDefinition(c, stateAnnotation));
            }
        }
    }

    private Function<TypeDefinition, Class<?>> toClass() {
        return new Function<TypeDefinition, Class<?>>(){

            public Class<?> apply(TypeDefinition input) {
                return input.cls;
            }
        };
    }

    private Predicate<TypeDefinition> withType(TypeDefinition.Type ... types) {
        final HashSet withTypes = Sets.newHashSet((Object[])types);
        return new Predicate<TypeDefinition>(){

            public boolean apply(TypeDefinition input) {
                return withTypes.contains((Object)input.type);
            }
        };
    }

    private Predicate<TypeDefinition> withTypeAndClass(final TypeDefinition.Type type, final Class<?> clazz) {
        return new Predicate<TypeDefinition>(){

            public boolean apply(TypeDefinition input) {
                return input.type == type && input.cls.equals(clazz);
            }
        };
    }

    private <T> Set<T> getAnnotatedWith(Class<T> type, Class<? extends Annotation> annotation) {
        if (type.equals(Field.class)) {
            return this.reflections.getFieldsAnnotatedWith(annotation);
        }
        if (type.equals(Method.class)) {
            return this.reflections.getMethodsAnnotatedWith(annotation);
        }
        if (type.equals(Class.class)) {
            return this.reflections.getTypesAnnotatedWith(annotation);
        }
        throw new RuntimeException("unknown type: " + type);
    }

    private String getFsmName(Class<?> fsmClass) {
        StateMachine annotation = fsmClass.getAnnotation(StateMachine.class);
        if (annotation == null) {
            throw new RuntimeException("fsm: " + fsmClass + " must be annotated with StateMachine");
        }
        return !Strings.isNullOrEmpty((String)annotation.name()) ? annotation.name() : fsmClass.getClass().getName();
    }

    private Reflections setupReflections(ClassLoader classLoader) {
        final Set<String> pkgs = this.getPackages(this.fsm.getClass());
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder().addClassLoader(classLoader).addUrls(new URL[]{this.tmpDir()}).forPackages(pkgs.toArray(new String[0])).filterInputsBy((Predicate)new Predicate<String>(){

            public boolean apply(final @Nullable String file) {
                boolean any = Iterables.any((Iterable)pkgs, (Predicate)new Predicate<String>(){

                    public boolean apply(String pkg) {
                        return file.startsWith(pkg);
                    }
                });
                return any;
            }
        }).addScanners(new Scanner[]{new MethodAnnotationsScanner(), new MethodParameterScanner(), new FieldAnnotationsScanner()});
        return new Reflections((Configuration)configurationBuilder);
    }

    private URL tmpDir() {
        try {
            return new File(System.getProperty("java.io.tmpdir")).toURI().toURL();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Set<String> getPackages(Class<?> fsmClass) {
        StateMachine annotation = fsmClass.getAnnotation(StateMachine.class);
        HashSet answer = Sets.newHashSet();
        if (annotation != null) {
            answer = Sets.newHashSet((Object[])annotation.pkgs());
        }
        if (answer.isEmpty()) {
            answer = Sets.newHashSet((Object[])new String[]{fsmClass.getPackage().getName()});
        }
        return answer;
    }

    Optional<Set<Method>> findTransitionForEvent(Class<?> stateClass, Object event) {
        Set transitions = ReflectionUtils.getAllMethods(stateClass, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(Transition.class), ReflectionUtils.withParameters((Class[])new Class[]{event.getClass()})});
        if (transitions.isEmpty()) {
            return Optional.absent();
        }
        if (transitions.size() > 1) {
            return Optional.of((Object)transitions);
        }
        Method transition = (Method)transitions.iterator().next();
        TypeDefinition stateDefinition = this.typeMap.get(transition.getReturnType());
        if (stateDefinition == null) {
            return Optional.absent();
        }
        return Optional.of((Object)Sets.newHashSet((Object[])new Method[]{transition}));
    }

    Set<Method> findActionImpliedMethods(Class<?> cls) {
        Set methods = ReflectionUtils.getAllMethods(cls, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(Action.class), this.withActionType(ActionType.Implied), ReflectionUtils.withParameters((Class[])new Class[0])});
        methods.addAll(ReflectionUtils.getAllMethods(cls, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(Action.class), this.withActionType(ActionType.Implied), ReflectionUtils.withParameters((Class[])new Class[]{this.fsm.getClass()})}));
        return methods;
    }

    Set<Method> findActionOnExitMethods(Class<?> cls) {
        Set methods = ReflectionUtils.getAllMethods(cls, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(Action.class), this.withActionType(ActionType.OnExit), ReflectionUtils.withParameters((Class[])new Class[0])});
        methods.addAll(ReflectionUtils.getAllMethods(cls, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(Action.class), this.withActionType(ActionType.OnExit), ReflectionUtils.withParameters((Class[])new Class[]{this.fsm.getClass()})}));
        return methods;
    }

    Set<Method> findActionOnEnterMethods(Class<?> cls) {
        Set methods = ReflectionUtils.getAllMethods(cls, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(Action.class), this.withActionType(ActionType.OnEnter), ReflectionUtils.withParameters((Class[])new Class[0])});
        methods.addAll(ReflectionUtils.getAllMethods(cls, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(Action.class), this.withActionType(ActionType.OnEnter), ReflectionUtils.withParameters((Class[])new Class[]{this.fsm.getClass()})}));
        return methods;
    }

    private Predicate<Method> withActionType(final ActionType actionType) {
        return new Predicate<Method>(){

            public boolean apply(@Nullable Method input) {
                return input.getAnnotation(Action.class).value() == actionType;
            }
        };
    }

    static class TypeDefinition<T> {
        private final Type type;
        private final Class<T> cls;
        private final Set<TransitionOnTimeoutEvent> timeoutEvents = Sets.newHashSet();

        private TypeDefinition(Class<T> cls, Class<? extends Annotation> stateAnnotation) {
            this.type = Type.from(stateAnnotation);
            this.cls = cls;
        }

        public String toString() {
            return "StateDefinition{cls=" + this.cls + ", type=" + (Object)((Object)this.type) + '}';
        }

        public void addTimeout(TransitionOnTimeoutEvent transitionOnTimeoutEvent) {
            this.timeoutEvents.add(transitionOnTimeoutEvent);
        }

        static enum Type {
            START_STATE,
            STATE,
            TIMER_EVENT;


            public static Type from(Class<? extends Annotation> annotationType) {
                if (annotationType.equals(State.class)) {
                    return STATE;
                }
                if (annotationType.equals(StartState.class)) {
                    return START_STATE;
                }
                if (annotationType.equals(TimerEvent.class)) {
                    return TIMER_EVENT;
                }
                throw new RuntimeException("unknown annotationType: " + annotationType);
            }
        }
    }
}

