/*
 * Decompiled with CFR 0.152.
 */
package jibe.tools.fsm.core;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Service;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import jibe.tools.fsm.annotations.StateMachine;
import jibe.tools.fsm.annotations.TimerEvent;
import jibe.tools.fsm.api.Context;
import jibe.tools.fsm.api.Engine;
import jibe.tools.fsm.core.EngineHelper;
import jibe.tools.fsm.core.TransitionOnTimeoutEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEngine<F, E>
extends AbstractExecutionThreadService
implements Engine<F, E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultEngine.class);
    private final Engine.Configuration configuration;
    private final F fsm;
    private Map<Class<?>, Object> instanceMap = Maps.newHashMap();
    private ExecutorService executorService;
    private ScheduledExecutorService scheduledExecutorService;
    private DefaultContext context;
    private EngineHelper helper;
    private BlockingQueue<E> queue;
    private CountDownLatch startLatch = new CountDownLatch(1);
    private Map<Object, ScheduledFuture> scheduledFutures = Maps.newHashMap();
    private static final Object DUDE = new Object();

    DefaultEngine(F fsm) {
        this(fsm, new DefaultConfiguration());
    }

    DefaultEngine(F fsm, Engine.Configuration configuration) {
        if (fsm.getClass().getAnnotation(StateMachine.class) == null) {
            throw new RuntimeException("fsm: " + fsm + " need to be annotated with @" + StateMachine.class.getName());
        }
        this.fsm = fsm;
        this.configuration = new DefaultConfiguration().merge(configuration);
        if (fsm instanceof Service.Listener) {
            this.addListener((Service.Listener)fsm, this.executor());
        }
        this.configure(configuration);
    }

    public static ConfigurationBuilder configurationBuilder() {
        return new ConfigurationBuilder();
    }

    private void configure(Engine.Configuration configuration) {
        this.helper = new EngineHelper(this);
        this.context = new DefaultContext();
        this.queue = new LinkedBlockingQueue(configuration.getQueueSize());
        this.executorService = configuration.getExecutorService();
        this.scheduledExecutorService = configuration.getScheduledExecutorService();
    }

    private void timerAtFixedRate(E timerEvent, long delay, long period, TimeUnit timeUnit) {
        ScheduledFuture<?> scheduledFuture = this.scheduledExecutorService.scheduleAtFixedRate(() -> {
            if (this.isRunning() && this.getSnapshot().getCurrentState().isPresent()) {
                this.event(timerEvent);
            }
        }, delay, period, timeUnit);
        this.scheduledFutures.put(timerEvent, scheduledFuture);
    }

    private void timerAt(E timerEvent, long delay, TimeUnit timeUnit) {
        ScheduledFuture<?> scheduledFuture = this.scheduledExecutorService.schedule(() -> {
            if (this.isRunning() && this.getSnapshot().getCurrentState().isPresent()) {
                this.event(timerEvent);
            }
        }, delay, timeUnit);
        this.scheduledFutures.put(timerEvent, scheduledFuture);
    }

    @Override
    public F getFsm() {
        return this.fsm;
    }

    @Override
    public Engine start() {
        LOGGER.debug("start");
        Engine engine = (Engine)this.startAsync();
        engine.awaitRunning();
        LOGGER.debug("service running");
        try {
            boolean await = this.startLatch.await(2L, TimeUnit.SECONDS);
            if (!await) {
                throw new RuntimeException("not started in time");
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return engine;
    }

    @Override
    public Engine stop() {
        Engine engine = (Engine)this.stopAsync();
        engine.awaitTerminated();
        return engine;
    }

    @Override
    public void event(E event) {
        if (!this.isRunning()) {
            throw new IllegalStateException("not running");
        }
        try {
            this.queue(event);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fire(Object event) {
        Object object = DUDE;
        synchronized (object) {
            if (ServiceEvent.START == event) {
                int foundNbrStartStates;
                this.startLatch.countDown();
                Optional<Set<Class<?>>> startStates = this.helper.findStartState();
                int n = foundNbrStartStates = startStates.isPresent() ? ((Set)startStates.get()).size() : 0;
                if (foundNbrStartStates != 1) {
                    if (foundNbrStartStates == 0) {
                        LOGGER.error("no start-state found");
                    }
                    this.triggerShutdown();
                    return;
                }
                Class startStateClass = (Class)((Set)startStates.get()).iterator().next();
                this.executeActionImplied(this.instanceMap(startStateClass));
                this.executeActionOnEnter(this.instanceMap(startStateClass));
                this.context.currentState = startStateClass;
                for (TransitionOnTimeoutEvent e : this.helper.getTimeoutTransitions(this.context.currentState)) {
                    this.timerAt(e, e.getPeriod(), e.getTimeUnit());
                }
                return;
            }
            this.executeActionImplied(event);
            Class<?> currentStateClass = this.context.currentState;
            Optional foundTransitions = event instanceof TransitionOnTimeoutEvent ? Optional.of((Object)Sets.newHashSet((Object[])new Method[]{((TransitionOnTimeoutEvent)event).getTimeOutMethod()})) : this.helper.findTransitionForEvent(currentStateClass, event);
            if (!foundTransitions.isPresent()) {
                return;
            }
            if (((Set)foundTransitions.get()).size() > 1) {
                LOGGER.error("to many transitions found: " + foundTransitions.get());
                this.triggerShutdown();
                return;
            }
            Method transitionMethod = (Method)((Set)foundTransitions.get()).iterator().next();
            Optional<Class<?>> foundToState = this.helper.findStateClass(transitionMethod.getReturnType());
            if (!foundToState.isPresent()) {
                throw new RuntimeException("transition returns something that is not a known state");
            }
            try {
                Object result;
                transitionMethod.setAccessible(true);
                Object[] methodArgs = new Object[]{};
                if (transitionMethod.getParameterTypes().length == 1) {
                    methodArgs = new Object[]{event};
                }
                if ((result = transitionMethod.invoke(this.instanceMap(currentStateClass), methodArgs)) == null) {
                    return;
                }
                this.executeActionImplied(this.instanceMap(currentStateClass));
                this.executeActionOnExit(this.instanceMap(currentStateClass));
                for (TransitionOnTimeoutEvent e : this.helper.getTimeoutTransitions(currentStateClass)) {
                    if (!this.scheduledFutures.containsKey(e)) continue;
                    this.scheduledFutures.get(e).cancel(false);
                }
                currentStateClass = result.getClass();
                this.context.previousState = this.context.currentState;
                this.context.currentState = result.getClass();
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
            this.executeActionImplied(this.instanceMap(currentStateClass));
            this.executeActionOnEnter(this.instanceMap(currentStateClass));
            for (TransitionOnTimeoutEvent e : this.helper.getTimeoutTransitions(currentStateClass)) {
                this.timerAt(e, e.getPeriod(), e.getTimeUnit());
            }
        }
    }

    private Object instanceMap(Class<?> cls) {
        Object o = this.instanceMap.get(cls);
        if (o != null) {
            return o;
        }
        try {
            Constructor<?> declaredConstructor = cls.getDeclaredConstructor(this.fsm.getClass());
            declaredConstructor.setAccessible(true);
            this.instanceMap.put(cls, declaredConstructor.newInstance(this.fsm));
        }
        catch (NoSuchMethodException e) {
            try {
                Constructor<?> declaredConstructor = cls.getDeclaredConstructor(new Class[0]);
                declaredConstructor.setAccessible(true);
                this.instanceMap.put(cls, declaredConstructor.newInstance(new Object[0]));
            }
            catch (Exception e2) {
                throw Throwables.propagate((Throwable)e2);
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return this.instanceMap.get(cls);
    }

    @Override
    public Engine.Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Engine.Snapshot getSnapshot() {
        return () -> {
            Object object = DUDE;
            synchronized (object) {
                return Optional.fromNullable((Object)this.context.currentState);
            }
        };
    }

    private void executeActionImplied(Object obj) {
        for (Method m : this.helper.findActionImpliedMethods(obj.getClass())) {
            this.executeAction(obj, m);
        }
    }

    private void executeActionOnEnter(Object obj) {
        for (Method m : this.helper.findActionOnEnterMethods(obj.getClass())) {
            this.executeAction(obj, m);
        }
    }

    private void executeActionOnExit(Object obj) {
        for (Method m : this.helper.findActionOnExitMethods(obj.getClass())) {
            this.executeAction(obj, m);
        }
    }

    private void executeAction(Object obj, Method m) {
        Class<?> returnType = m.getReturnType();
        if (!returnType.equals(Void.TYPE)) {
            LOGGER.warn("invoking Action with return-type: " + returnType + ". I don't know what to do with it...");
        }
        try {
            m.setAccessible(true);
            if (m.getParameterTypes().length == 1) {
                m.invoke(obj, this.fsm);
            } else {
                m.invoke(obj, new Object[0]);
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected Executor executor() {
        return this.executorService;
    }

    protected void shutDown() throws Exception {
        LOGGER.info("shutDown");
        this.executorService.shutdownNow();
        this.scheduledExecutorService.shutdownNow();
        LOGGER.debug("executorServices is now shutdown");
    }

    protected void startUp() throws Exception {
        LOGGER.info("startUp");
        this.scheduleTimerEvents(this.helper.getTimerEvents());
        this.queue(ServiceEvent.START);
    }

    private void scheduleTimerEvents(Set<E> timerEvents) {
        block4: for (E timerEvent : timerEvents) {
            TimerEvent annotation = timerEvent.getClass().getAnnotation(TimerEvent.class);
            switch (annotation.type()) {
                case ScheduledFixedRateTimer: {
                    this.timerAtFixedRate(timerEvent, annotation.delay(), annotation.period(), annotation.timeUnit());
                    continue block4;
                }
                case ScheduledTimer: {
                    this.timerAt(timerEvent, annotation.delay(), annotation.timeUnit());
                    continue block4;
                }
            }
            throw new RuntimeException("unknown timer type...");
        }
    }

    private <T> void queue(T event) {
        try {
            this.queue.add(event);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected void triggerShutdown() {
        LOGGER.info("triggerShutdown");
        this.queue(ServiceEvent.STOP);
    }

    protected void run() throws Exception {
        while (this.isRunning()) {
            E event = this.queue.take();
            if (ServiceEvent.STOP != event) {
                this.fire(event);
                continue;
            }
            LOGGER.debug("Leaving main-loop");
            return;
        }
        LOGGER.debug("Leaving main-loop");
    }

    private class DefaultContext
    implements Context {
        private Class<?> currentState = null;
        private Class<?> previousState = null;

        private DefaultContext() {
        }
    }

    public static class DefaultConfiguration
    implements Engine.Configuration {
        private ThreadFactory threadFactory = MoreExecutors.platformThreadFactory();
        private ExecutorService executorService = Executors.newFixedThreadPool(10, this.threadFactory);
        private ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(10, this.threadFactory);
        private int queueSize = 1024;
        private long actionTimeoutMills = 1000L;
        private long transitionTimeoutMills = 1000L;
        private ClassLoader classLoader = DefaultConfiguration.class.getClassLoader();

        private DefaultConfiguration() {
        }

        DefaultConfiguration merge(Engine.Configuration configuration) {
            ClassLoader classLoader;
            ScheduledExecutorService scheduledExecutorService;
            ExecutorService executorService;
            ThreadFactory threadFactory;
            Integer queueSize;
            Long transitionTimeoutMillis;
            Long actionTimeoutMillis = configuration.getActionTimeoutMillis();
            if (actionTimeoutMillis != null) {
                this.setActionTimeoutMills(actionTimeoutMillis);
            }
            if ((transitionTimeoutMillis = configuration.getTransitionTimeoutMillis()) != null) {
                this.setTransitionTimeoutMills(transitionTimeoutMillis);
            }
            if ((queueSize = configuration.getQueueSize()) != null) {
                this.setQueueSize(queueSize);
            }
            if ((threadFactory = configuration.getThreadFactory()) != null) {
                this.setThreadFactory(threadFactory);
            }
            if ((executorService = configuration.getExecutorService()) != null) {
                this.setExecutorService(executorService);
            }
            if ((scheduledExecutorService = configuration.getScheduledExecutorService()) != null) {
                this.setScheduledExecutorService(scheduledExecutorService);
            }
            if ((classLoader = configuration.getClassLoader()) != null) {
                this.setClassLoader(classLoader);
            }
            return this;
        }

        @Override
        public ThreadFactory getThreadFactory() {
            return this.threadFactory;
        }

        void setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = Objects.requireNonNull(threadFactory);
        }

        @Override
        public ExecutorService getExecutorService() {
            return this.executorService;
        }

        void setExecutorService(ExecutorService executorService) {
            this.executorService = Objects.requireNonNull(executorService);
        }

        @Override
        public ScheduledExecutorService getScheduledExecutorService() {
            return this.scheduledExecutorService;
        }

        void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            this.scheduledExecutorService = Objects.requireNonNull(scheduledExecutorService);
        }

        @Override
        public Integer getQueueSize() {
            return this.queueSize;
        }

        void setQueueSize(int queueSize) {
            this.queueSize = (int)this.assertPositiveNotZero(queueSize);
        }

        @Override
        public Long getActionTimeoutMillis() {
            return this.actionTimeoutMills;
        }

        @Override
        public Long getTransitionTimeoutMillis() {
            return this.transitionTimeoutMills;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        void setClassLoader(ClassLoader classLoader) {
            this.classLoader = Objects.requireNonNull(classLoader);
        }

        void setActionTimeoutMills(long actionTimeoutMills) {
            this.actionTimeoutMills = this.assertPositiveNotZero(actionTimeoutMills);
        }

        void setTransitionTimeoutMills(long transitionTimeoutMills) {
            this.transitionTimeoutMills = this.assertPositiveNotZero(transitionTimeoutMills);
        }

        private long assertPositiveNotZero(long value) {
            if (value > 0L) {
                return value;
            }
            throw new RuntimeException("timeouts must be a positive number > 0");
        }
    }

    public static class ConfigurationBuilder {
        private final DefaultConfiguration configuration = new DefaultConfiguration();

        public ConfigurationBuilder threadFactory(ThreadFactory threadFactory) {
            this.configuration.setThreadFactory(threadFactory);
            return this;
        }

        public ConfigurationBuilder executorService(ExecutorService executorService) {
            this.configuration.setExecutorService(executorService);
            return this;
        }

        public ConfigurationBuilder queueSize(int queueSize) {
            this.configuration.setQueueSize(queueSize);
            return this;
        }

        public ConfigurationBuilder actionTimeoutMills(long millis) {
            this.configuration.setActionTimeoutMills(millis);
            return this;
        }

        public ConfigurationBuilder transitionTimeoutMills(long millis) {
            this.configuration.setTransitionTimeoutMills(millis);
            return this;
        }

        Engine.Configuration build() {
            return this.configuration;
        }

        public ConfigurationBuilder classLoader(ClassLoader classLoader) {
            this.configuration.setClassLoader(classLoader);
            return this;
        }
    }

    private static enum ServiceEvent {
        START,
        STOP;

    }
}

