/*
 * Decompiled with CFR 0.152.
 */
package jibe.tools.fsm.builder;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import jibe.tools.fsm.annotations.State;
import jibe.tools.fsm.annotations.StateMachine;
import jibe.tools.fsm.api.Engine;
import jibe.tools.fsm.builder.StateBuilder;
import jibe.tools.fsm.builder.TransitionBuilder;
import jibe.tools.fsm.core.DefaultEngine;
import jibe.tools.fsm.core.EngineFactory;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSMBuilder<T extends StateBuilder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FSMBuilder.class);
    final String packageName;
    private final CtClass stateMachine;
    private final Map<String, CtClass> stateMap = Maps.newHashMap();
    private final Set<T> stateBuilders = Sets.newHashSet();

    public FSMBuilder() {
        this.packageName = "jibe.tools.fsm.builder." + RandomStringUtils.randomAlphabetic((int)5);
        ClassPool classPool = ClassPool.getDefault();
        try {
            classPool.makePackage(classPool.getClassLoader(), this.packageName);
            this.stateMachine = this.makeClassWithAnnotation(this.packageName + ".StateMachine", StateMachine.class);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static TransitionBuilder transition(String name) {
        return new TransitionBuilder(name);
    }

    private Class<?> writeFile(CtClass ctClass) {
        try {
            ctClass.writeFile(System.getProperty("java.io.tmpdir"));
            return ctClass.toClass();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Engine build() {
        try {
            HashSet stateFacades = Sets.newHashSet();
            for (StateBuilder sb : this.stateBuilders) {
                StateBuilder.StateFacade stateFacade = sb.build();
                stateFacades.add(stateFacade);
                String className = this.packageName + "." + stateFacade.getName();
                this.stateMap.put(className, this.makeClassWithAnnotation(className, stateFacade.getAnnotationClass()));
            }
            HashSet transitionFacades = Sets.newHashSet();
            for (StateBuilder.StateFacade sf : stateFacades) {
                for (TransitionBuilder.TransitionFacade tf : sf.getTransitions()) {
                    transitionFacades.add(tf);
                    String toState = tf.getToState();
                    String className = this.packageName + "." + toState;
                    this.stateMap.put(className, this.makeClassWithAnnotation(className, State.class));
                }
            }
            for (CtClass ctClass : this.stateMap.values()) {
                ctClass.writeFile(System.getProperty("java.io.tmpdir"));
            }
            return EngineFactory.newInstance().newEngine(this.writeFile(this.stateMachine).newInstance(), DefaultEngine.configurationBuilder().classLoader(this.newClassLoader()));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    CtClass makeClassWithAnnotation(String className, Class<? extends Annotation> annotationClass) {
        if (!className.startsWith(this.packageName)) {
            className = this.packageName + "." + className;
        }
        ClassPool cp = ClassPool.getDefault();
        try {
            return cp.get(className);
        }
        catch (NotFoundException e) {
            CtClass ctClass = cp.makeClass(className);
            ClassFile classFile = ctClass.getClassFile();
            ConstPool constPool = classFile.getConstPool();
            AnnotationsAttribute attr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
            javassist.bytecode.annotation.Annotation annotation = new javassist.bytecode.annotation.Annotation(annotationClass.getName(), constPool);
            attr.setAnnotation(annotation);
            classFile.addAttribute((AttributeInfo)attr);
            return ctClass;
        }
    }

    void makeTransitionMethod(CtClass declaringClass, CtClass toState, Object event) {
        String methodTemplate = "@jibe.tools.fsm.annotations.Transitionpublic %s %s(%s event) {  %s;}";
    }

    private ClassLoader newClassLoader() {
        ArrayList urLs = Lists.newArrayList((Object[])((URLClassLoader)FSMBuilder.class.getClassLoader()).getURLs());
        try {
            urLs.add(new File(System.getProperty("java.io.tmpdir")).toURI().toURL());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return new MyClassLoader(urLs.toArray(new URL[0]));
    }

    public T addStateBuilder(T stateBuilder) {
        this.stateBuilders.add(stateBuilder);
        return stateBuilder;
    }

    public class MyClassLoader
    extends URLClassLoader {
        public MyClassLoader(URL[] urls) {
            super(urls);
        }
    }
}

