/*
 * Decompiled with CFR 0.152.
 */
package jibe.tools.maven.plugin.erb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.filtering.PropertyUtils;

@Mojo(name="run", requiresProject=false)
public class ErbMojo
extends AbstractMojo {
    private static String rbInit = "require 'erb'\nrequire 'ostruct'\nrequire 'java'\n\ndef render(template, variables)\n  context = OpenStruct.new(variables).instance_eval do\n    variables.each do |k, v|\n      instance_variable_set(k, v) if k[0] == '@'\n    end\n    binding\n  end\n  ERB.new(template.to_io.read).result(context);\nend\n";
    @Parameter(name="templateFile", required=true)
    private URL templateFile;
    @Parameter(name="erbVariablesFile", required=false)
    private File erbVariablesFile;
    @Parameter(name="propertiesFile", required=false)
    private File propertiesFile;
    @Parameter(name="properties", required=false)
    private Map<String, String> properties;
    @Parameter(name="outputFile", required=false)
    private File outputFile;
    @Parameter(name="sslTrustAllServers", required=false)
    private boolean sslTrustAllServers;
    @Parameter(name="skip", required=false)
    private boolean skip;
    private InputStream templateInputStream;
    private OutputStream resultOutputStream;
    private ScriptEngine jruby;
    private Properties erbVariables;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"execution skipped");
            return;
        }
        try {
            HashMap<String, Object> rbVariables = new HashMap<String, Object>();
            for (Map.Entry<Object, Object> e : this.erbVariables().entrySet()) {
                String key = e.getKey().toString();
                if (!key.startsWith("@")) {
                    key = "@" + key;
                }
                rbVariables.put(key, e.getValue());
            }
            String result = this.jruby().invokeFunction("render", this.templateInputStream(), rbVariables).toString();
            OutputStream outputStream = this.resultOutputStream();
            outputStream.write(result.getBytes());
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private Invocable jruby() {
        if (this.jruby == null) {
            this.jruby = new ScriptEngineManager().getEngineByName("jruby");
            try {
                this.jruby.eval(rbInit);
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
        }
        return (Invocable)((Object)this.jruby);
    }

    private InputStream templateInputStream() throws IOException {
        if (this.templateInputStream != null) {
            return this.templateInputStream;
        }
        if (this.templateFile.getProtocol().equals("https") && this.sslTrustAllServers) {
            this.sslAllTrusted();
        }
        return this.templateFile.openStream();
    }

    private Properties erbVariables() throws IOException {
        if (this.erbVariables != null) {
            return this.erbVariables;
        }
        if (this.erbVariablesFile == null) {
            return new Properties();
        }
        Properties baseProperties = new Properties();
        if (this.propertiesFile != null) {
            try {
                baseProperties.load(new FileInputStream(this.propertiesFile));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.properties != null) {
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                baseProperties.put(entry.getKey(), entry.getValue());
            }
        }
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            baseProperties.put(entry.getKey(), entry.getValue());
        }
        return PropertyUtils.loadPropertyFile((File)this.erbVariablesFile, (Properties)baseProperties);
    }

    private OutputStream resultOutputStream() {
        if (this.resultOutputStream != null) {
            return this.resultOutputStream;
        }
        if (this.outputFile == null) {
            return System.out;
        }
        if (!this.outputFile.getParentFile().exists()) {
            this.outputFile.getParentFile().mkdirs();
        }
        try {
            this.resultOutputStream = new FileOutputStream(this.outputFile);
            return this.resultOutputStream;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    Properties getErbVariables() {
        return this.erbVariables;
    }

    void setErbVariables(Properties erbVariables) {
        this.erbVariables = erbVariables;
    }

    public InputStream getTemplateInputStream() {
        return this.templateInputStream;
    }

    void setTemplateInputStream(InputStream testTemplateInputStream) {
        this.templateInputStream = testTemplateInputStream;
    }

    public OutputStream getResultOutputStream() {
        return this.resultOutputStream;
    }

    void setResultOutputStream(OutputStream resultOutputStream) {
        this.resultOutputStream = resultOutputStream;
    }

    private void sslAllTrusted() {
        SSLContext sc;
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
    }
}

