/*
 * Decompiled with CFR 0.152.
 */
package nu.ganslandt.util.commlog;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import nu.ganslandt.util.commlog.Stringer;
import nu.ganslandt.util.commlog.StringerSource;

public class MapStringer
extends Stringer {
    private final StringerSource source;
    private Collection<String> globalSecrets;

    public MapStringer(StringerSource source, int maxPropertyDepth) {
        super(maxPropertyDepth);
        this.source = source;
        this.globalSecrets = new HashSet<String>();
    }

    @Override
    String doStringify(Object object, int level) {
        if (!(object instanceof Map)) {
            throw new IllegalArgumentException("MapStringer can only string Maps.");
        }
        Map map = (Map)object;
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        for (Object key : map.keySet()) {
            builder.append(this.source.getStringer(key).toString(key, level));
            builder.append(": ");
            if (this.globalSecrets.contains(key)) {
                builder.append("********");
                builder.append(", ");
                continue;
            }
            Object entry = map.get(key);
            builder.append(this.source.getStringer(entry).toString(entry, level));
            builder.append(", ");
        }
        if (builder.length() >= 2) {
            builder.delete(builder.length() - 2, builder.length());
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public void addSecret(String propertyName) {
        this.globalSecrets.add(propertyName);
    }
}

