/*
 * Decompiled with CFR 0.152.
 */
package nu.ganslandt.util.commlog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import nu.ganslandt.util.commlog.CollectionStringer;
import nu.ganslandt.util.commlog.Stringer;
import nu.ganslandt.util.commlog.StringerSource;

public class ArrayStringer
extends Stringer {
    private final CollectionStringer collectionStringer;

    public ArrayStringer(StringerSource source, int maxPropertyDepth) {
        super(maxPropertyDepth);
        this.collectionStringer = new CollectionStringer(source, maxPropertyDepth);
    }

    @Override
    String doStringify(Object obj, int level) {
        if (obj.getClass().equals(char[].class)) {
            return this.collectionStringer.toString(this.buildCollection((char[])obj), level);
        }
        if (obj.getClass().equals(byte[].class)) {
            return this.collectionStringer.toString(this.buildCollection((byte[])obj), level);
        }
        if (obj.getClass().equals(short[].class)) {
            return this.collectionStringer.toString(this.buildCollection((short[])obj), level);
        }
        if (obj.getClass().equals(int[].class)) {
            return this.collectionStringer.toString(this.buildCollection((int[])obj), level);
        }
        if (obj.getClass().equals(long[].class)) {
            return this.collectionStringer.toString(this.buildCollection((long[])obj), level);
        }
        if (obj.getClass().equals(float[].class)) {
            return this.collectionStringer.toString(this.buildCollection((float[])obj), level);
        }
        if (obj.getClass().equals(double[].class)) {
            return this.collectionStringer.toString(this.buildCollection((double[])obj), level);
        }
        if (obj.getClass().equals(boolean[].class)) {
            return this.collectionStringer.toString(this.buildCollection((boolean[])obj), level);
        }
        return this.collectionStringer.toString(Arrays.asList((Object[])obj), level);
    }

    private Collection buildCollection(char[] array) {
        ArrayList<Character> characterCollection = new ArrayList<Character>(array.length);
        for (char e : array) {
            characterCollection.add(Character.valueOf(e));
        }
        return characterCollection;
    }

    private Collection buildCollection(byte[] array) {
        ArrayList<Byte> characterCollection = new ArrayList<Byte>(array.length);
        for (byte e : array) {
            characterCollection.add(e);
        }
        return characterCollection;
    }

    private Collection buildCollection(short[] array) {
        ArrayList<Short> characterCollection = new ArrayList<Short>(array.length);
        short[] sArray = array;
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            Short e = sArray[i];
            characterCollection.add(e);
        }
        return characterCollection;
    }

    private Collection buildCollection(int[] array) {
        ArrayList<Integer> characterCollection = new ArrayList<Integer>(array.length);
        for (int e : array) {
            characterCollection.add(e);
        }
        return characterCollection;
    }

    private Collection buildCollection(long[] array) {
        ArrayList<Long> characterCollection = new ArrayList<Long>(array.length);
        for (long e : array) {
            characterCollection.add(e);
        }
        return characterCollection;
    }

    private Collection buildCollection(float[] array) {
        ArrayList<Float> characterCollection = new ArrayList<Float>(array.length);
        for (float e : array) {
            characterCollection.add(Float.valueOf(e));
        }
        return characterCollection;
    }

    private Collection buildCollection(double[] array) {
        ArrayList<Double> characterCollection = new ArrayList<Double>(array.length);
        for (double e : array) {
            characterCollection.add(e);
        }
        return characterCollection;
    }

    private Collection buildCollection(boolean[] array) {
        ArrayList<Boolean> characterCollection = new ArrayList<Boolean>(array.length);
        for (boolean e : array) {
            characterCollection.add(e);
        }
        return characterCollection;
    }

    @Override
    public void addSecret(String propertyName) {
    }
}

