/*
 * Decompiled with CFR 0.152.
 */
package nu.ganslandt.util.commlog;

import java.util.LinkedHashMap;
import nu.ganslandt.util.commlog.CommLogImpl;
import nu.ganslandt.util.commlog.ReflectingPropertyStringer;
import nu.ganslandt.util.commlog.ValueClassWithSecret;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SecretsTest {
    private CommLogImpl commLog;

    @Before
    public void setup() {
        this.commLog = (CommLogImpl)CommLogImpl.getLog((String)"TestLog");
        this.commLog.addSecret("secretProperty");
    }

    @Test
    public void testMapStringer_stringMapsWithContent() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("result_code", "0");
        linkedHashMap.put("result_message", "Failed: Nothing is returned.");
        linkedHashMap.put("result_output", "json");
        linkedHashMap.put("secretProperty", "verySecretIndeed");
        String s = this.commLog.getStringer(linkedHashMap).toString(linkedHashMap);
        Assert.assertEquals((Object)"{'result_code': '0', 'result_message': 'Failed: Nothing is returned.', 'result_output': 'json', 'secretProperty': ********}", (Object)s);
    }

    @Test
    public void testReflectingPropertyStringer_masksSecretProperties() {
        this.commLog.configureStringerForPackage("nu.ganslandt.util.commlog", ReflectingPropertyStringer.class);
        ValueClassWithSecret value = new ValueClassWithSecret("abc", 123, new ValueClassWithSecret("def", 456, ""), "verySecretIndeed");
        String s = this.commLog.getStringer((Object)value).toString((Object)value);
        Assert.assertEquals((Object)"{value1='abc', value2=123, optionalNestedValue={value1='def', value2=456, optionalNestedValue=null, secretProperty=********}, secretProperty=********}", (Object)s);
    }
}

