/*
 * Decompiled with CFR 0.152.
 */
package nu.ganslandt.util.commlog;

import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.UUID;
import nu.ganslandt.util.commlog.CommLogImpl;
import nu.ganslandt.util.commlog.Enum;
import nu.ganslandt.util.commlog.ReflectingPropertyStringer;
import nu.ganslandt.util.commlog.Stringer;
import nu.ganslandt.util.commlog.StringerSource;
import nu.ganslandt.util.commlog.SubValueClass;
import nu.ganslandt.util.commlog.ValueClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CommLogTest {
    private CommLogImpl commLog;

    @Before
    public void setup() {
        this.commLog = (CommLogImpl)CommLogImpl.getLog((String)UUID.randomUUID().toString());
        this.commLog.addSecret("secretProperty");
    }

    @Test
    public void testToStringStringer_stringsStrings() {
        String string = "abc22@ganslandt.nu";
        String s = this.commLog.getStringer((Object)string).toString((Object)string);
        Assert.assertEquals((Object)("'" + string + "'"), (Object)s);
    }

    @Test
    public void testToStringStringer_stringsIntegers() {
        Integer integer = 10;
        String s = this.commLog.getStringer((Object)integer).toString((Object)integer);
        Assert.assertEquals((Object)"10", (Object)s);
    }

    @Test
    public void testCollectionStringer_stringsEmptyCollections() {
        LinkedList linkedList = new LinkedList();
        String s = this.commLog.getStringer(linkedList).toString(linkedList);
        Assert.assertEquals((Object)"[]", (Object)s);
    }

    @Test
    public void testCollectionStringer_stringsCollectionsWithContent() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("abc");
        linkedList.add("123");
        String s = this.commLog.getStringer(linkedList).toString(linkedList);
        Assert.assertEquals((Object)"['abc', '123']", (Object)s);
    }

    @Test
    public void testMapStringer_stringsEmptyMaps() {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        String s = this.commLog.getStringer(linkedHashMap).toString(linkedHashMap);
        Assert.assertEquals((Object)"{}", (Object)s);
    }

    @Test
    public void testMapStringer_stringMapsWithContent() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("result_code", "0");
        linkedHashMap.put("result_message", "Failed: Nothing is returned.");
        linkedHashMap.put("result_output", "json");
        String s = this.commLog.getStringer(linkedHashMap).toString(linkedHashMap);
        Assert.assertEquals((Object)"{'result_code': '0', 'result_message': 'Failed: Nothing is returned.', 'result_output': 'json'}", (Object)s);
    }

    @Test
    public void testReflectingPropertyStringer_getsUsedWhenConfiguredViaClass() {
        this.commLog.configureStringerForClass(ValueClass.class, ReflectingPropertyStringer.class);
        ValueClass value = new ValueClass("abc", 123, new ValueClass("def", 456));
        String s = this.commLog.getStringer((Object)value).toString((Object)value);
        Assert.assertEquals((Object)"{value1='abc', value2=123, optionalNestedValue={value1='def', value2=456, optionalNestedValue=null}}", (Object)s);
    }

    @Test
    public void testReflectingPropertyStringer_logsSuperClassAttributesWhenSubClassIsLogs() {
        this.commLog.configureStringerForClass(SubValueClass.class, ReflectingPropertyStringer.class);
        SubValueClass value = new SubValueClass("abc", (Integer)123, 11);
        String s = this.commLog.getStringer((Object)value).toString((Object)value);
        Assert.assertEquals((Object)"{value3=11, value1='abc', value2=123, optionalNestedValue=null}", (Object)s);
    }

    @Test
    public void testReflectingPropertyStringer_getsUsedWhenConfiguredViaPackage() {
        this.commLog.configureStringerForPackage("nu.ganslandt.util.commlog", ReflectingPropertyStringer.class);
        ValueClass value = new ValueClass("abc", 123, new ValueClass("def", 456));
        String s = this.commLog.getStringer((Object)value).toString((Object)value);
        Assert.assertEquals((Object)"{value1='abc', value2=123, optionalNestedValue={value1='def', value2=456, optionalNestedValue=null}}", (Object)s);
    }

    @Test
    public void testReflectingPropertyStringer_canLogEnums() {
        this.commLog.configureStringerForPackage("nu.ganslandt.util.commlog", ReflectingPropertyStringer.class);
        String s = this.commLog.getStringer((Object)Enum.FAILURE).toString((Object)Enum.FAILURE);
        Assert.assertEquals((Object)"FAILURE", (Object)s);
    }

    @Test
    public void testReflectingPropertyStringer_withEnum() {
        this.commLog.configureStringerForClass(TestClassWithEnum.class, ReflectingPropertyStringer.class);
        this.commLog.configureStringerForClass(Enum.class, ReflectingPropertyStringer.class);
        TestClassWithEnum value = new TestClassWithEnum();
        value.setTheEnum(Enum.SUCCESS);
        String s = this.commLog.getStringer((Object)value).toString((Object)value);
        Assert.assertEquals((Object)"{theEnum=SUCCESS}", (Object)s);
    }

    @Test
    public void testNullStringer() {
        String s = this.commLog.getStringer(null).toString(null);
        Assert.assertEquals((Object)"null", (Object)s);
    }

    @Test
    public void testMapString_withNullEntry() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("value", null);
        String s = this.commLog.getStringer(linkedHashMap).toString(linkedHashMap);
        Assert.assertEquals((Object)"{'value': null}", (Object)s);
    }

    @Test
    public void testMapStringer_withMapContent() {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        linkedHashMap.put("value", new LinkedHashMap());
        String s = this.commLog.getStringer(linkedHashMap).toString(linkedHashMap);
        Assert.assertEquals((Object)"{'value': {}}", (Object)s);
    }

    @Test
    public void testArrayStringer_withEmptyArray() {
        Object[] objects = new Object[]{};
        String s = this.commLog.getStringer((Object)objects).toString((Object)objects);
        Assert.assertEquals((Object)"[]", (Object)s);
    }

    @Test
    public void testArrayStringer_withStringArrayAndNullValues() {
        String[] objects = new String[3];
        objects[0] = "abc";
        String s = this.commLog.getStringer((Object)objects).toString((Object)objects);
        Assert.assertEquals((Object)"['abc', null, null]", (Object)s);
    }

    @Test
    public void testArrayStringer_withVariousContent() {
        Object[] objects = new Object[]{"abc", 123, 1.23};
        String s = this.commLog.getStringer((Object)objects).toString((Object)objects);
        Assert.assertEquals((Object)"['abc', 123, 1.23]", (Object)s);
    }

    @Test
    public void testArrayStringer_withObjectsHavingConfiguredStringer() {
        Object[] objects = new Object[]{"abc", new ValueClass("abc", 123)};
        this.commLog.configureStringerForClass(ValueClass.class, ReflectingPropertyStringer.class);
        String s = this.commLog.getStringer((Object)objects).toString((Object)objects);
        Assert.assertEquals((Object)"['abc', {value1='abc', value2=123, optionalNestedValue=null}]", (Object)s);
    }

    @Test
    public void testArrayStringer_withPrimitiveArrays() {
        this.testArrayStringer_withPrimitiveArray(new char[]{'1', '2'}, "[1, 2]");
        this.testArrayStringer_withPrimitiveArray(new byte[]{1, 2}, "[1, 2]");
        this.testArrayStringer_withPrimitiveArray(new short[]{1, 2}, "[1, 2]");
        this.testArrayStringer_withPrimitiveArray(new int[]{1, 2}, "[1, 2]");
        this.testArrayStringer_withPrimitiveArray(new long[]{1L, 2L}, "[1, 2]");
        this.testArrayStringer_withPrimitiveArray(new float[]{1.0f, 2.0f}, "[1.0, 2.0]");
        this.testArrayStringer_withPrimitiveArray(new double[]{1.0, 2.0}, "[1.0, 2.0]");
        this.testArrayStringer_withPrimitiveArray(new boolean[]{true, false}, "[true, false]");
    }

    private void testArrayStringer_withPrimitiveArray(Object array, String expectedResult) {
        String s = this.commLog.getStringer(array).toString(array);
        Assert.assertEquals((Object)expectedResult, (Object)s);
    }

    @Test
    public void testStringify_primitives() {
        int intPrimitive = 123;
        String s = this.commLog.getStringer((Object)intPrimitive).toString((Object)intPrimitive);
        Assert.assertEquals((Object)"123", (Object)s);
        boolean boolPrimitive = true;
        s = this.commLog.getStringer((Object)boolPrimitive).toString((Object)boolPrimitive);
        Assert.assertEquals((Object)"true", (Object)s);
        double doublePrimitive = 1.23;
        s = this.commLog.getStringer((Object)doublePrimitive).toString((Object)doublePrimitive);
        Assert.assertEquals((Object)"1.23", (Object)s);
    }

    @Test
    public void testStringifyURI_getsCorrectStringRepresentation() {
        URI uri = URI.create("http://host/path?queryParam=paramValue&queryParam2=paramValue2");
        Assert.assertEquals((String)"Invalid precondition, failed to parse URI string?", (Object)"http", (Object)uri.getScheme());
        Assert.assertEquals((String)"Invalid precondition, failed to parse URI string?", (Object)"host", (Object)uri.getHost());
        Assert.assertEquals((String)"Invalid precondition, failed to parse URI string?", (Object)"/path", (Object)uri.getPath());
        Assert.assertEquals((String)"Invalid precondition, failed to parse URI string?", (Object)"queryParam=paramValue&queryParam2=paramValue2", (Object)uri.getQuery());
        String s = this.commLog.getStringer((Object)uri).toString((Object)uri);
        Assert.assertEquals((Object)"http://host/path?queryParam=paramValue&queryParam2=paramValue2", (Object)s);
    }

    @Test
    public void testFoulStringer_exceptionDoesntPropagate() {
        this.commLog.configureStringerForClass(TestClass.class, FoulStringer.class);
        this.commLog.request("test", (Object)new TestClass());
        this.commLog.response((Object)new TestClass());
    }

    @Test
    public void testFoulStringer_producesInformativeMessage() {
        this.commLog.configureStringerForClass(ValueClass.class, ReflectingPropertyStringer.class);
        this.commLog.configureStringerForClass(Integer.class, FoulStringer.class);
        ValueClass value = new ValueClass("value", 2);
        String s = this.commLog.getStringer((Object)value).toString((Object)value);
        Assert.assertEquals((Object)"{value1='value', value2=Failed to Stringify an instance of class java.lang.Integer (java.lang.RuntimeException: Failure!!!), optionalNestedValue=null}", (Object)s);
    }

    public void testCollectionStringer_doesntStackOverflow() {
        LinkedList list = new LinkedList();
        list.add(list);
        this.commLog.getStringer(list).toString(list);
    }

    @Test
    public void testArrayStringer_doesntStackOverflow() {
        Object[] array;
        array[0] = array = new Object[1];
        this.commLog.getStringer((Object)array).toString((Object)array);
    }

    @Test
    public void testMapStringer_doesntStackOverflow() {
        HashMap map = new HashMap();
        map.put("map", map);
        this.commLog.getStringer(map).toString(map);
    }

    @Test
    public void testReflectionPropertyStringer_doesntStackOverflow() {
        TestClass testClass = new TestClass();
        testClass.setData(testClass);
        this.commLog.configureStringerForClass(TestClass.class, ReflectingPropertyStringer.class);
        String string = this.commLog.getStringer((Object)testClass).toString((Object)testClass);
        System.out.println(string);
        Assert.assertTrue((!string.contains("java.lang.StackOverflowError") ? 1 : 0) != 0);
    }

    private static class FoulStringer
    extends Stringer {
        FoulStringer(StringerSource source, int maxPropertyDepth) {
            super(maxPropertyDepth);
        }

        String doStringify(Object obj, int level) {
            throw new RuntimeException("Failure!!!");
        }

        public void addSecret(String propertyName) {
        }
    }

    private static class TestClassWithEnum {
        private Enum theEnum;

        private TestClassWithEnum() {
        }

        public void setTheEnum(Enum theEnum) {
            this.theEnum = theEnum;
        }
    }

    private static class TestClass {
        private Object data;

        private TestClass() {
        }

        public void setData(Object data) {
            this.data = data;
        }
    }
}

