/*
 * Decompiled with CFR 0.152.
 */
package nu.ganslandt.util.commlog;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import nu.ganslandt.util.commlog.Stringer;
import nu.ganslandt.util.commlog.StringerSource;

public class ReflectingPropertyStringer
extends Stringer {
    private StringerSource source;
    private Collection<String> globalSecrets;

    protected ReflectingPropertyStringer(StringerSource source, int maxPropertyDepth) {
        super(maxPropertyDepth);
        this.source = source;
        this.globalSecrets = new HashSet<String>();
    }

    @Override
    String doStringify(Object obj, int level) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        Class<?> clazz = obj.getClass();
        while (!clazz.equals(Object.class)) {
            for (Field f : clazz.getDeclaredFields()) {
                String value;
                if (Modifier.isTransient(f.getModifiers())) continue;
                try {
                    f.setAccessible(true);
                    value = this.globalSecrets.contains(f.getName()) ? f.getName() + "=" + "********" : (f.get(obj) != null ? f.getName() + "=" + this.source.getStringer(f.get(obj)).toString(f.get(obj), level) : f.getName() + "=" + null);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    value = "###ERROR###";
                }
                sb.append(value).append(", ");
            }
            clazz = clazz.getSuperclass();
        }
        if (sb.length() > 1) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void addSecret(String propertyName) {
        this.globalSecrets.add(propertyName);
    }
}

