/*
 * Decompiled with CFR 0.152.
 */
package nu.ganslandt.util.commlog;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import nu.ganslandt.util.commlog.ArrayStringer;
import nu.ganslandt.util.commlog.CollectionStringer;
import nu.ganslandt.util.commlog.CommLog;
import nu.ganslandt.util.commlog.MapStringer;
import nu.ganslandt.util.commlog.Request;
import nu.ganslandt.util.commlog.Stringer;
import nu.ganslandt.util.commlog.StringerSource;
import nu.ganslandt.util.commlog.ToStringStringer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommLogImpl
implements CommLog,
StringerSource {
    private static Map<String, CommLogImpl> loggers = new ConcurrentHashMap<String, CommLogImpl>();
    private final Logger COMM;
    private final Logger ERROR;
    private Map<Class, Stringer> stringerMap;
    private Map<String, Stringer> packageNameStringerMap;
    private Collection<String> globalSecrets;
    private int maxPropertyDepth = 10;
    private ThreadLocal<Request> request;
    private Stringer defaultStringer;

    private CommLogImpl(String name) {
        this.COMM = LoggerFactory.getLogger((String)(name + "-Comm"));
        this.ERROR = LoggerFactory.getLogger((String)(name + "-Error"));
        this.request = new ThreadLocal();
        this.stringerMap = new ConcurrentHashMap<Class, Stringer>();
        this.packageNameStringerMap = new ConcurrentHashMap<String, Stringer>();
        this.globalSecrets = new HashSet<String>();
        this.defaultStringer = new ToStringStringer(this.maxPropertyDepth);
    }

    public static CommLog getLog(String name) {
        CommLogImpl log = loggers.get(name);
        if (log == null) {
            log = new CommLogImpl(name);
            loggers.put(name, log);
        }
        log.initStringerMap();
        return log;
    }

    @Override
    public boolean hasStringerFor(Object obj) {
        return this.getSpecializedStringerFor(obj) != null;
    }

    @Override
    public Stringer getStringer(Object obj) {
        if (obj == null) {
            return this.defaultStringer;
        }
        Stringer stringer = this.getSpecializedStringerFor(obj);
        if (stringer != null) {
            return stringer;
        }
        stringer = this.getSpecializedStringerForPackage(obj.getClass().getPackage().getName());
        if (stringer != null) {
            return stringer;
        }
        return this.defaultStringer;
    }

    private Stringer getSpecializedStringerFor(Object obj) {
        if (obj.getClass().isArray()) {
            return new ArrayStringer(this, this.maxPropertyDepth);
        }
        if (obj.getClass().isEnum()) {
            return new ToStringStringer(this.maxPropertyDepth);
        }
        Stringer stringer = this.stringerMap.get(obj.getClass());
        if (stringer == null) {
            for (Class c : this.stringerMap.keySet()) {
                if (!c.isAssignableFrom(obj.getClass())) continue;
                stringer = this.stringerMap.get(c);
            }
        }
        return stringer;
    }

    private Stringer getSpecializedStringerForPackage(String packageName) {
        return this.packageNameStringerMap.get(packageName);
    }

    private void initStringerMap() {
        this.stringerMap.put(Collection.class, new CollectionStringer(this, this.maxPropertyDepth));
        this.stringerMap.put(Map.class, new MapStringer(this, this.maxPropertyDepth));
    }

    @Override
    public void request(String requestName, Object request) {
        this.request.set(new Request(requestName));
        this.COMM.info("Request: [{}] {}({})", new Object[]{this.request.get().getUUID(), requestName, this.getStringer(request).toString(request)});
    }

    @Override
    public void request(String requestName) {
        this.request.set(new Request(requestName));
        this.COMM.info("Request: [{}] {}()", new Object[]{this.request.get().getUUID(), requestName});
    }

    @Override
    public void configureStringerForClass(Class clazz, Class<? extends Stringer> stringerClass) {
        this.stringerMap.put(clazz, this.getConfiguredStringer(stringerClass));
    }

    @Override
    public void configureStringerForPackage(String packageName, Class<? extends Stringer> stringerClass) {
        this.packageNameStringerMap.put(packageName, this.getConfiguredStringer(stringerClass));
    }

    @Override
    public void addSecret(String propertyName) {
        this.globalSecrets.add(propertyName);
        this.defaultStringer.addSecret(propertyName);
        for (Stringer stringer : this.stringerMap.values()) {
            stringer.addSecret(propertyName);
        }
        for (Stringer stringer : this.packageNameStringerMap.values()) {
            stringer.addSecret(propertyName);
        }
    }

    @Override
    public void setMaxPropertyDepth(int maxPropertyDepth) {
        this.maxPropertyDepth = maxPropertyDepth;
        this.defaultStringer = new ToStringStringer(maxPropertyDepth);
    }

    private Stringer getConfiguredStringer(Class<? extends Stringer> stringerClass) {
        Stringer stringer = null;
        for (Map.Entry<Class, Stringer> e : this.stringerMap.entrySet()) {
            if (!e.getValue().getClass().equals(stringerClass)) continue;
            stringer = e.getValue();
        }
        if (stringer == null) {
            Constructor<? extends Stringer> constructor = this.getPreferredConstructor(stringerClass);
            try {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length == 2 && parameterTypes[0].equals(StringerSource.class) && parameterTypes[1].equals(Integer.TYPE)) {
                    stringer = constructor.newInstance(this, this.maxPropertyDepth);
                } else if (parameterTypes.length == 1) {
                    stringer = constructor.newInstance(this.maxPropertyDepth);
                } else if (parameterTypes.length == 0) {
                    stringer = constructor.newInstance(new Object[0]);
                } else {
                    throw new RuntimeException("Don't know how to construct a " + stringerClass.getName());
                }
                for (String secret : this.globalSecrets) {
                    stringer.addSecret(secret);
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return stringer;
    }

    private Constructor<? extends Stringer> getPreferredConstructor(Class<? extends Stringer> stringerClass) {
        Constructor<? extends Stringer> preferredConstructor = null;
        try {
            preferredConstructor = stringerClass.getDeclaredConstructor(StringerSource.class, Integer.TYPE);
        }
        catch (NoSuchMethodException ignored) {
            try {
                preferredConstructor = stringerClass.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (preferredConstructor == null) {
            throw new RuntimeException("Found neither a no args constructor or one taking a StringerSource.");
        }
        return preferredConstructor;
    }

    @Override
    public void response() {
        String requestName;
        String uuid;
        Request request = this.request.get();
        if (request != null) {
            uuid = request.getUUID();
            requestName = request.getRequestName();
            this.request.remove();
        } else {
            uuid = "";
            requestName = "";
        }
        this.COMM.info("Response: [{}] {}({})", new Object[]{uuid, requestName, "void"});
    }

    @Override
    public <T> T response(T response) {
        String requestName;
        String uuid;
        Request request = this.request.get();
        if (request != null) {
            uuid = request.getUUID();
            requestName = request.getRequestName();
            this.request.remove();
        } else {
            uuid = "";
            requestName = "";
        }
        this.COMM.info("Response: [{}] {}({})", new Object[]{uuid, requestName, this.getStringer(response).toString(response)});
        return response;
    }

    @Override
    public <T> T error(T response) {
        String requestName;
        String uuid;
        Request request = this.request.get();
        if (request != null) {
            uuid = request.getUUID();
            requestName = request.getRequestName();
            this.request.remove();
        } else {
            uuid = "";
            requestName = "";
        }
        this.COMM.error("Error: [{}] {}({})", new Object[]{uuid, requestName, this.getStringer(response).toString(response)});
        return response;
    }

    @Override
    public <T extends Throwable> T error(T t, boolean comm) {
        String uuid = null;
        String requestName = null;
        Request request = this.request.get();
        if (request != null) {
            uuid = request.getUUID();
            requestName = request.getRequestName();
        }
        if (comm) {
            this.COMM.error("Error: [{}] {}({})", new Object[]{uuid, requestName, t.toString()});
            this.request.remove();
        }
        this.ERROR.error("Error: [{}]", (Object)uuid, t);
        return t;
    }

    @Override
    public <R, T extends Throwable> R error(T t, R response) {
        String uuid = null;
        String requestName = null;
        Request request = this.request.get();
        if (request != null) {
            uuid = request.getUUID();
            requestName = request.getRequestName();
            this.request.remove();
        } else {
            uuid = "";
            requestName = "";
        }
        this.COMM.error("Error: [{}] {}({})", new Object[]{uuid, requestName, this.getStringer(response).toString(response)});
        this.ERROR.error("Error: [{}]", (Object)uuid, t);
        return response;
    }
}

