/*
 * Decompiled with CFR 0.152.
 */
package nu.ganslandt.util.commlog;

import java.util.Collection;
import nu.ganslandt.util.commlog.Stringer;
import nu.ganslandt.util.commlog.StringerSource;

public class CollectionStringer
extends Stringer {
    private StringerSource source;

    public CollectionStringer(StringerSource source, int maxPropertyDepth) {
        super(maxPropertyDepth);
        this.source = source;
    }

    @Override
    String doStringify(Object object, int level) {
        if (!(object instanceof Collection)) {
            throw new IllegalArgumentException("CollectionStringer can only string Collections.");
        }
        Collection collection = (Collection)object;
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (Object item : collection) {
            builder.append(this.source.getStringer(item).toString(item, level));
            builder.append(", ");
        }
        if (builder.length() >= 2) {
            builder.delete(builder.length() - 2, builder.length());
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public void addSecret(String propertyName) {
    }
}

