/*
 * Decompiled with CFR 0.152.
 */
package nu.aron.next;

import io.vavr.collection.List;
import io.vavr.control.Try;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import nu.aron.next.Activation;
import nu.aron.next.Activator;
import nu.aron.next.BranchName;
import nu.aron.next.Constants;
import nu.aron.next.CurrentWorkingDirectory;
import nu.aron.next.GitRevision;
import nu.aron.next.Incrementable;
import nu.aron.next.Modelbuilder;
import nu.aron.next.PluginException;
import nu.aron.next.RemoteVersion;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.io.ModelWriter;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.fusesource.jansi.AnsiConsole;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="NextBuildNumberLifecycleParticipant")
public class NextBuildNumberLifecycleParticipant
extends AbstractMavenLifecycleParticipant
implements Incrementable,
GitRevision,
RemoteVersion,
Activator,
BranchName,
Modelbuilder {
    @Requirement
    private ModelWriter modelWriter;
    @Requirement
    private ModelReader modelReader;
    private final Activation active = this::activated;

    public void afterSessionStart(MavenSession session) throws MavenExecutionException {
        AnsiConsole.systemInstall();
        this.doWork(this::revision, session);
        this.doWork(this::version, session);
        this.doWork(this::write, session);
        AnsiConsole.systemUninstall();
    }

    private void doWork(Consumer<MavenSession> c, MavenSession s) throws MavenExecutionException {
        try {
            c.accept(s);
        }
        catch (PluginException e) {
            throw new MavenExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private void version(MavenSession session) {
        File pom = session.getRequest().getPom().getAbsoluteFile();
        Model model = (Model)this.modelFromFile(pom, this.modelReader).getOrElse((Object)new Model());
        if (this.isEmptyModel(model)) {
            Constants.log("Unable to create maven model. Skipping.", new String[0]);
            session.getUserProperties().put("next.skip", "true");
        } else {
            this.checkVersionPresent(model);
        }
        if (this.active.test(session)) {
            String version = this.manuallyBumped(model.getVersion(), this.getCurrent(session, model));
            Constants.log("Latest released version {}", version);
            String nextVersion = this.newVersion(version, this.branchName(CurrentWorkingDirectory.getCwd(session)), 1);
            session.getSystemProperties().setProperty("nextversion.version", nextVersion);
            Constants.log("Next version {}", nextVersion);
        }
    }

    private boolean isEmptyModel(Model model) {
        return "[inherited]:null:jar:[inherited]".equals(model.toString());
    }

    private void write(MavenSession session) {
        if (this.active.test(session)) {
            File pom = session.getRequest().getPom().getAbsoluteFile();
            Model model = (Model)this.modelFromFile(pom, this.modelReader).get();
            String nextVersion = session.getSystemProperties().getProperty("nextversion.version", model.getVersion());
            this.saveValues(nextVersion, session, model);
            this.findModels(List.of((Object)model), this.modelReader).forEach(m -> this.persistVersion(nextVersion, (Model)m));
        }
    }

    private void checkVersionPresent(Model model) {
        if (Objects.isNull(model.getVersion())) {
            Constants.logError("No version present in pom.", new String[0]);
            throw new PluginException(new Throwable("No version"));
        }
    }

    private void persistVersion(String nextVersion, Model model) {
        model.setVersion(nextVersion);
        Try.run(() -> this.modelWriter.write(model.getPomFile(), null, model)).onFailure(e -> Constants.logError("Failed to write ", e.getMessage()));
    }

    private void saveValues(String nextVersion, MavenSession session, Model model) {
        Properties p = new Properties();
        p.put("commit", session.getSystemProperties().get("nextversion.commit"));
        p.put("version", nextVersion);
        p.put("artifactId", model.getArtifactId());
        p.put("groupId", this.groupIdFromModel(model));
        p.put("gav", String.join((CharSequence)":", this.groupIdFromModel(model), model.getArtifactId(), nextVersion));
        File target = Paths.get("target", new String[0]).toFile();
        if (!target.mkdir() && !target.exists()) {
            Constants.logError("Unable to create target directory!", new String[0]);
            throw new PluginException(new IllegalStateException("Unable to create target directory"));
        }
        Try.run(() -> p.store(new FileOutputStream("target/nextversion.properties"), null)).onFailure(e -> Constants.logError("Failed to write ", e.getMessage()));
    }
}

