/*
 * Decompiled with CFR 0.152.
 */
package nu.aron.next;

import io.vavr.control.Option;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import nu.aron.next.PluginException;
import org.apache.commons.io.input.NullInputStream;
import org.fusesource.jansi.Ansi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Constants {
    static final String EMPTY = "";
    static final String VERSION = "version";
    static final String COMMIT = "commit";
    static final String RUN = "run";
    static final String NEXT_COMMIT = "nextversion.commit";
    static final String NEXT_VERSION = "nextversion.version";
    static final String MASTER = "master";
    static final String GIT_BRANCH = "git rev-parse --abbrev-ref HEAD";
    static final String GIT_REVISION = "git rev-parse HEAD";
    static final String SNAPSHOT = "SNAPSHOT";
    static final String ARTIFACT_ID = "artifactId";
    static final String GROUP_ID = "groupId";
    static final String NEXTVERSION_MAVEN_PLUGIN = "nextversion-maven-plugin";
    static Logger logger = LoggerFactory.getLogger((String)"nextversion-maven-plugin");
    private static final String LOGNAME = String.join((CharSequence)":", "nextversion-maven-plugin", Constants.version(), "run");

    private Constants() {
    }

    private static String version() {
        Option stream = Option.of((Object)Constants.class.getClassLoader().getResourceAsStream("META-INF/maven/nu.aron/nextversion-maven-plugin/pom.properties"));
        try {
            Properties p = new Properties();
            p.load((InputStream)stream.getOrElse((Object)new NullInputStream(0L)));
            return String.valueOf(p.get(VERSION));
        }
        catch (IOException e) {
            throw new PluginException(e);
        }
    }

    static void log(String message, String ... args) {
        logger.info("--- " + Ansi.ansi().fgGreen().a(LOGNAME).reset() + " ---");
        logger.info(message, (Object[])args);
    }

    static void logError(String message, String ... args) {
        logger.error("--- " + Ansi.ansi().fgGreen().a(LOGNAME).reset() + " ---");
        logger.error(message, (Object[])args);
    }
}

