/*
 * Decompiled with CFR 0.152.
 */
package nu.aron.nextbuildnumber;

import io.vavr.CheckedFunction0;
import io.vavr.collection.List;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import nu.aron.nextbuildnumber.Constants;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;

interface RemoteVersion {
    public static final String releaseOpen = "<release>";
    public static final String releaseClose = "</release>";

    default public String getCurrent(MavenSession session, Model model) {
        return (String)this.versionFromString(this.xmlData(session, model)).onEmpty(() -> Constants.log("No previous release found for {}. Will use version from pom and remove \"-SNAPSHOT\"", (String)Option.of((Object)model.getGroupId()).getOrElse((Object)model.getParent().getGroupId()) + ":" + model.getArtifactId(), model.getVersion())).getOrElse((Object)this.removeEnd(model.getVersion(), "-SNAPSHOT"));
    }

    default public String xmlData(MavenSession session, Model model) {
        return List.ofAll((Iterable)session.getRequest().getProjectBuildingRequest().getRemoteRepositories()).map(ArtifactRepository::getUrl).map(u -> this.urlFromRepo((String)u, model)).map(this::responseToString).reject(this::notFound).toCharSeq().toString();
    }

    private String urlFromRepo(String repoUrl, Model model) {
        String groupId = this.groupIdFromModel(model);
        return String.join((CharSequence)"/", this.removeEnd(repoUrl, "/"), groupId.replace('.', '/'), model.getArtifactId(), "maven-metadata.xml");
    }

    private String responseToString(String url) {
        HttpRequest request = HttpRequest.newBuilder(URI.create(url)).build();
        return (String)((HttpResponse)Try.of((CheckedFunction0 & Serializable)() -> HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString())).get()).body();
    }

    private boolean notFound(String s) {
        return s.contains("404 Not Found");
    }

    default public String removeEnd(String str, String remove) {
        if (str.endsWith(remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    default public Option<String> versionFromString(String str) {
        return this.validVersionInString(str).map(s -> {
            int start = str.indexOf(releaseOpen);
            int end = str.indexOf(releaseClose, start + releaseOpen.length());
            return str.substring(start + releaseOpen.length(), end);
        });
    }

    default public Option<String> validVersionInString(String str) {
        if (str.isEmpty() || !str.contains(releaseOpen) || !str.contains(releaseClose)) {
            return Option.none();
        }
        return Option.of((Object)str);
    }

    default public String groupIdFromModel(Model model) {
        return (String)Option.of((Object)model.getGroupId()).getOrElse(() -> model.getParent().getGroupId());
    }
}

