/*
 * Decompiled with CFR 0.152.
 */
package nu.aron.nextbuildnumber;

import io.vavr.collection.List;
import io.vavr.control.Try;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.function.Consumer;
import nu.aron.nextbuildnumber.Activation;
import nu.aron.nextbuildnumber.Activator;
import nu.aron.nextbuildnumber.BranchName;
import nu.aron.nextbuildnumber.Constants;
import nu.aron.nextbuildnumber.CurrentWorkingDirectory;
import nu.aron.nextbuildnumber.GitRevision;
import nu.aron.nextbuildnumber.Incrementable;
import nu.aron.nextbuildnumber.Modelbuilder;
import nu.aron.nextbuildnumber.PluginException;
import nu.aron.nextbuildnumber.RemoteVersion;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.io.ModelWriter;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.fusesource.jansi.AnsiConsole;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="NextBuildNumberLifecycleParticipant")
public class NextBuildNumberLifecycleParticipant
extends AbstractMavenLifecycleParticipant
implements Incrementable,
GitRevision,
RemoteVersion,
Activator,
BranchName,
Modelbuilder {
    @Requirement
    private ModelWriter modelWriter;
    @Requirement
    private ModelReader modelReader;
    private final Activation active = this::activated;

    public void afterSessionStart(MavenSession session) throws MavenExecutionException {
        AnsiConsole.systemInstall();
        if (this.active.test(session)) {
            Constants.log("Version will be incremented and commit property will be set.", new String[0]);
            this.doWork(this::setRevision, session);
            this.doWork(this::witeNewVersion, session);
        }
        AnsiConsole.systemUninstall();
    }

    private void doWork(Consumer<MavenSession> c, MavenSession s) throws MavenExecutionException {
        try {
            c.accept(s);
        }
        catch (PluginException e) {
            throw new MavenExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private void witeNewVersion(MavenSession session) {
        File pom = session.getRequest().getPom().getAbsoluteFile();
        Model model = this.modelFromFile(pom, this.modelReader);
        this.checkModel(model);
        model.getProperties().put("nextversion.commit", session.getSystemProperties().get("nextversion.commit"));
        String version = this.manuallyBumped(model.getVersion(), this.getCurrent(session, model));
        Constants.log("Latest released version {}", version);
        String nextVersion = this.newVersion(version, this.branchName(CurrentWorkingDirectory.getCwd(session)), 1);
        session.getSystemProperties().setProperty("nextversion.version", nextVersion);
        Constants.log("Next version {}", nextVersion);
        this.saveValues(nextVersion, session, model);
        this.findModels(List.of((Object)model), this.modelReader).forEach(m -> this.persistVersion(nextVersion, (Model)m));
    }

    private void checkModel(Model model) {
        if (model.getVersion() == null) {
            Constants.log("No version present in pom.", new String[0]);
            throw new PluginException(new Throwable("No version"));
        }
    }

    private void persistVersion(String nextVersion, Model model) {
        model.setVersion(nextVersion);
        Try.run(() -> this.modelWriter.write(model.getPomFile(), null, model)).onFailure(e -> Constants.log("Failed to write ", e.getMessage()));
    }

    private void saveValues(String nextVersion, MavenSession session, Model model) {
        Properties p = new Properties();
        p.put("commit", session.getSystemProperties().get("nextversion.commit"));
        p.put("version", nextVersion);
        p.put("gav", String.join((CharSequence)":", this.groupIdFromModel(model), model.getArtifactId(), nextVersion));
        Try.run(() -> p.store(new FileOutputStream("target/nextversion.properties"), null)).onFailure(e -> Constants.log("Failed to write ", e.getMessage()));
    }
}

