/*
 * Decompiled with CFR 0.152.
 */
package nu.aron.nextbuildnumber;

import java.util.Objects;
import nu.aron.nextbuildnumber.Constants;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

interface Incrementable {
    default public String newVersion(String currentVersion, String branch, int increment) {
        DefaultArtifactVersion version = new DefaultArtifactVersion(currentVersion);
        if (this.countDots(currentVersion) == 0) {
            return this.addBranch(String.valueOf(version.getMajorVersion() + increment), branch);
        }
        if (this.countDots(currentVersion) == 1) {
            return this.addBranch(String.format("%d.%d", version.getMajorVersion(), version.getMinorVersion() + increment), branch);
        }
        return this.addBranch(String.format("%d.%d.%d", version.getMajorVersion(), version.getMinorVersion(), version.getIncrementalVersion() + increment), branch);
    }

    private String addBranch(String version, String branch) {
        if (branch.equals("master") || StringUtils.isEmpty((CharSequence)branch)) {
            return version;
        }
        return version + "-" + branch.replace("/", "-");
    }

    default public int countDots(CharSequence str) {
        return (int)str.chars().filter(c -> c == 46).count();
    }

    default public String manuallyBumped(String pomVersion, String remoteVersion) {
        DefaultArtifactVersion pom = new DefaultArtifactVersion(pomVersion);
        DefaultArtifactVersion remote = new DefaultArtifactVersion(remoteVersion);
        if (this.isManual((ArtifactVersion)pom, (ArtifactVersion)remote)) {
            Constants.log("Manual version bump identified.", new String[0]);
            return this.newVersion(pomVersion, "", 0);
        }
        return remoteVersion;
    }

    private boolean isManual(ArtifactVersion pom, ArtifactVersion remote) {
        if (1 == pom.compareTo((Object)remote)) {
            return Objects.isNull(pom.getQualifier()) || "SNAPSHOT".equals(pom.getQualifier());
        }
        return false;
    }
}

