/*
 * Decompiled with CFR 0.152.
 */
package nu.aron.nextbuildnumber;

import io.vavr.CheckedFunction0;
import io.vavr.collection.List;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import nu.aron.nextbuildnumber.Constants;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;

interface RemoteVersion {
    default public String getCurrent(MavenSession session, Model model) {
        String xmlData = this.xmlData(session, model);
        return (String)this.versionFromString(xmlData).onEmpty(() -> Constants.log("No previous release found for {}. Will use version from pom and remove \"-SNAPSHOT\"", (String)Option.of((Object)model.getGroupId()).getOrElse((Object)model.getParent().getGroupId()) + ":" + model.getArtifactId(), model.getVersion())).getOrElse((Object)RemoteVersion.removeEnd(model.getVersion(), "-SNAPSHOT"));
    }

    default public String xmlData(MavenSession session, Model model) {
        return List.ofAll((Iterable)session.getRequest().getProjectBuildingRequest().getRemoteRepositories()).map(ArtifactRepository::getUrl).map(u -> this.urlFromRepo((String)u, model)).map(this::responseToString).reject(this::notFound).toCharSeq().toString();
    }

    private Option<String> versionFromString(String data) {
        return Option.of((Object)RemoteVersion.substringBetween(data, "<release>", "</release>"));
    }

    private String urlFromRepo(String repoUrl, Model model) {
        String groupId = (String)Option.of((Object)model.getGroupId()).getOrElse(() -> model.getParent().getGroupId());
        return String.join((CharSequence)"/", RemoteVersion.removeEnd(repoUrl, "/"), groupId.replace('.', '/'), model.getArtifactId(), "maven-metadata.xml");
    }

    private String responseToString(String url) {
        HttpRequest request = HttpRequest.newBuilder(URI.create(url)).build();
        return (String)((HttpResponse)Try.of((CheckedFunction0 & Serializable)() -> HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString())).get()).body();
    }

    private boolean notFound(String s) {
        return s.contains("404 Not Found");
    }

    public static String substringBetween(String str, String open, String close) {
        int start = str.indexOf(open);
        int end = str.indexOf(close, start + open.length());
        return str.substring(start + open.length(), end);
    }

    public static String removeEnd(String str, String remove) {
        if (str.endsWith(remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }
}

