/*
 * Decompiled with CFR 0.152.
 */
package nu.aron.nextbuildnumber;

import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

interface Incrementable {
    default public String newVersion(String currentVersion, String branch) {
        DefaultArtifactVersion version = new DefaultArtifactVersion(currentVersion);
        if (this.countDots(currentVersion) == 0) {
            return this.addBranch(String.valueOf(version.getMajorVersion() + 1), branch);
        }
        if (this.countDots(currentVersion) == 1) {
            return this.addBranch(String.format("%d.%d", version.getMajorVersion(), version.getMinorVersion() + 1), branch);
        }
        return this.addBranch(String.format("%d.%d.%d", version.getMajorVersion(), version.getMinorVersion(), version.getIncrementalVersion() + 1), branch);
    }

    private String addBranch(String version, String branch) {
        if (branch.equals("master")) {
            return version;
        }
        return version + "-" + branch.replace("/", "-");
    }

    default public int countDots(CharSequence str) {
        return (int)str.chars().filter(c -> c == 46).count();
    }
}

