/*
 * Decompiled with CFR 0.152.
 */
package nu.aron.nextbuildnumber;

import io.vavr.control.Option;
import java.util.Properties;
import nu.aron.nextbuildnumber.Constants;
import nu.aron.nextbuildnumber.GetEnvPretender;
import org.apache.maven.execution.MavenSession;

interface Activator {
    default public boolean activated(MavenSession session, GetEnvPretender getEnvPretender) {
        if (this.skipped(session.getUserProperties())) {
            return false;
        }
        if (!this.isCiBuild(getEnvPretender) && this.hasDeployGoal(session)) {
            Constants.log("Activated by deploy goal. No CI detected.", new String[0]);
            return true;
        }
        if (this.isCiBuild(getEnvPretender)) {
            Constants.log("Detected CI build.", new String[0]);
            if (this.hasDeployDeployGoal(session)) {
                Constants.log("Using deploy:deploy assuming version already set. Skipping.", new String[0]);
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isCiBuild(GetEnvPretender getEnvPretender) {
        return Option.of((Object)getEnvPretender.getenv("BRANCH_NAME")).isDefined() || Option.of((Object)getEnvPretender.getenv("CI")).isDefined();
    }

    private boolean hasDeployGoal(MavenSession session) {
        return session.getRequest().getGoals().contains("deploy");
    }

    private boolean hasDeployDeployGoal(MavenSession session) {
        return session.getRequest().getGoals().contains("deploy:deploy");
    }

    private boolean skipped(Properties userProperties) {
        return Option.of((Object)userProperties.get("next.skip")).isDefined();
    }
}

