/*
 * Decompiled with CFR 0.152.
 */
package nu.aron.nextbuildnumber;

import io.vavr.collection.List;
import io.vavr.control.Option;
import kong.unirest.Unirest;
import nu.aron.nextbuildnumber.Constants;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;

interface RemoteVersion {
    default public String getCurrent(MavenSession session, Model model) {
        String xmlData = this.xmlData(session, model);
        return (String)this.versionFromString(xmlData).onEmpty(() -> Constants.log("No previous release found for {}. Will use version from pom and remove \"-SNAPSHOT\"", (String)Option.of((Object)model.getGroupId()).getOrElse((Object)model.getParent().getGroupId()) + ":" + model.getArtifactId(), model.getVersion())).getOrElse((Object)StringUtils.removeEnd((String)model.getVersion(), (String)"-SNAPSHOT"));
    }

    default public String xmlData(MavenSession session, Model model) {
        return List.ofAll((Iterable)session.getRequest().getProjectBuildingRequest().getRemoteRepositories()).map(ar -> ar.getUrl()).map(u -> this.urlFromRepo((String)u, model)).map(u -> (String)Unirest.get((String)u).asString().getBody()).reject(s -> s.contains("404 Not Found")).toCharSeq().toString();
    }

    private Option<String> versionFromString(String data) {
        return Option.of((Object)StringUtils.substringBetween((String)data, (String)"<release>", (String)"</release>"));
    }

    private String urlFromRepo(String repoUrl, Model model) {
        String groupId = (String)Option.of((Object)model.getGroupId()).getOrElse(() -> model.getParent().getGroupId());
        return String.join((CharSequence)"/", StringUtils.removeEnd((String)repoUrl, (String)"/"), groupId.replace('.', '/'), model.getArtifactId(), "maven-metadata.xml");
    }
}

