/*
 * Decompiled with CFR 0.152.
 */
package nu.aron.nextbuildnumber;

import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.codehaus.mojo.versions.ordering.MavenVersionComparator;

interface Incrementable {
    default public String newVersion(String currentVersion, String branch) {
        DefaultArtifactVersion version = new DefaultArtifactVersion(currentVersion);
        MavenVersionComparator versionComparator = new MavenVersionComparator();
        if (StringUtils.countMatches((CharSequence)currentVersion, (char)'.') == 0) {
            ArtifactVersion retval = versionComparator.incrementSegment((ArtifactVersion)version, 0);
            return this.addBranch(String.valueOf(retval.getMajorVersion()), branch);
        }
        if (StringUtils.countMatches((CharSequence)currentVersion, (char)'.') == 1) {
            ArtifactVersion retval = versionComparator.incrementSegment((ArtifactVersion)version, 1);
            return this.addBranch(String.format("%d.%d", retval.getMajorVersion(), retval.getMinorVersion()), branch);
        }
        return this.addBranch(versionComparator.incrementSegment((ArtifactVersion)version, 2).toString(), branch);
    }

    private String addBranch(String version, String branch) {
        if (branch.equals("master")) {
            return version;
        }
        return version + "-" + branch.replace("/", "-");
    }
}

