/*
 * Decompiled with CFR 0.152.
 */
package nu.aron.nextbuildnumber;

import io.vavr.CheckedFunction0;
import io.vavr.collection.List;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.File;
import java.io.Serializable;
import kong.unirest.Unirest;
import nu.aron.nextbuildnumber.Incrementable;
import nu.aron.nextbuildnumber.PluginException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.io.ModelWriter;
import org.apache.maven.shared.utils.cli.CommandLineUtils;
import org.apache.maven.shared.utils.cli.Commandline;
import org.apache.maven.shared.utils.cli.StreamConsumer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="NextBuildNumberLifecycleParticipant")
public class NextBuildNumberLifecycleParticipant
extends AbstractMavenLifecycleParticipant
implements Incrementable {
    private static final String COMMIT = "commit";
    private static Logger log = LoggerFactory.getLogger(NextBuildNumberLifecycleParticipant.class);
    @Requirement
    private ModelWriter modelWriter;
    @Requirement
    private ModelReader modelReader;

    public void afterSessionStart(MavenSession session) throws MavenExecutionException {
        File pom = session.getRequest().getPom().getAbsoluteFile();
        Model model = (Model)Try.of((CheckedFunction0 & Serializable)() -> this.modelReader.read(pom, null)).getOrElseThrow(e -> new MavenExecutionException(e.getMessage(), e));
        String xmlData = this.xmlData(session, model);
        String version = (String)this.versionFromString(xmlData).getOrElseThrow(() -> new MavenExecutionException("No data found", new Throwable()));
        String nextVersion = this.newVersion(version);
        log.info("Version {}", (Object)nextVersion);
        model.setVersion(nextVersion);
        Try.run(() -> this.modelWriter.write(pom, null, model));
    }

    private String xmlData(MavenSession session, Model model) {
        return List.ofAll((Iterable)session.getRequest().getProjectBuildingRequest().getRemoteRepositories()).map(ArtifactRepository::getUrl).map(u -> this.urlFromRepo((String)u, model)).map(u -> (String)Unirest.get((String)u).asString().getBody()).reject(s -> s.contains("404 Not Found")).toCharSeq().toString();
    }

    private Option<String> versionFromString(String data) {
        String[] found = StringUtils.substringsBetween((String)data, (String)"<latest>", (String)"</latest>");
        if (found.length == 0) {
            return Option.none();
        }
        return Option.of((Object)found[0]);
    }

    private String urlFromRepo(String repoUrl, Model model) {
        String groupId = (String)Option.of((Object)model.getGroupId()).getOrElse(() -> model.getParent().getGroupId());
        return String.join((CharSequence)"/", StringUtils.removeEnd((String)repoUrl, (String)"/"), groupId.replace('.', '/'), model.getArtifactId(), "maven-metadata.xml");
    }

    public final void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        if (this.isDryRun(session)) {
            log.info("Dry run. No actions will be taken.");
        } else {
            try {
                this.doWork(session);
            }
            catch (PluginException e) {
                throw new MavenExecutionException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean isDryRun(MavenSession s) {
        return Option.of((Object)s.getUserProperties().get("dryRun")).isDefined();
    }

    private void doWork(MavenSession session) {
        this.setGitRevision(session);
    }

    private void setGitRevision(MavenSession session) {
        this.logAndSetProperty(session, this.run(session.getCurrentProject().getBasedir()));
    }

    private String run(File workingDirectory) {
        Commandline cl = new Commandline("git rev-parse HEAD");
        cl.setWorkingDirectory(workingDirectory);
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        Try.of((CheckedFunction0 & Serializable)() -> CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)new LoggingConsumer())).getOrElseThrow(e -> new PluginException((Exception)e));
        return stdout.getOutput();
    }

    private void logAndSetProperty(MavenSession session, String value) {
        session.getSystemProperties().setProperty(COMMIT, value);
        session.getUserProperties().setProperty(COMMIT, value);
        session.getCurrentProject().getProperties().setProperty(COMMIT, value);
        log.info("{} set to {}", (Object)COMMIT, (Object)value);
    }

    private static class LoggingConsumer
    extends CommandLineUtils.StringStreamConsumer {
        private LoggingConsumer() {
        }

        public void consumeLine(String line) {
            log.error("{}", (Object)line);
        }
    }
}

