/*
 * Decompiled with CFR 0.152.
 */
package notclive.security.email.principals;

import java.util.ArrayList;
import java.util.List;
import notclive.security.email.principals.EmailSecurityAuthorities;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class EmailSecurityEmailKnownPrincipal
extends AbstractAuthenticationToken {
    private final String emailAddress;
    private final String secret;
    private final boolean rememberMe;

    public EmailSecurityEmailKnownPrincipal(String emailAddress, String secret, boolean rememberMe) {
        super(EmailSecurityEmailKnownPrincipal.emailKnownAuthority());
        this.emailAddress = emailAddress;
        this.secret = secret;
        this.rememberMe = rememberMe;
    }

    private static List<SimpleGrantedAuthority> emailKnownAuthority() {
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        authorities.add(EmailSecurityAuthorities.EMAIL_KNOWN);
        return authorities;
    }

    public Object getCredentials() {
        return this.secret;
    }

    public Object getPrincipal() {
        return this.emailAddress;
    }

    public boolean getRememberMe() {
        return this.rememberMe;
    }
}

