/*
 * Decompiled with CFR 0.152.
 */
package notclive.security.email;

import java.util.HashMap;
import java.util.Map;
import notclive.security.email.EmailSecurityToken;
import notclive.security.email.EmailSecurityTokenRepository;
import org.springframework.stereotype.Component;

@Component
public class InMemoryEmailSecurityTokenRepository
implements EmailSecurityTokenRepository {
    private final Map<String, EmailSecurityToken> tokensBySecret = new HashMap<String, EmailSecurityToken>();

    @Override
    public void store(EmailSecurityToken token) {
        this.tokensBySecret.put(token.getSecret(), token);
    }

    @Override
    public EmailSecurityToken authenticate(String secret) {
        if (this.tokensBySecret.containsKey(secret)) {
            EmailSecurityToken token = this.tokensBySecret.get(secret);
            EmailSecurityToken authenticatedToken = new EmailSecurityToken(token.getEmailAddress(), secret, true);
            this.store(authenticatedToken);
            return authenticatedToken;
        }
        return null;
    }

    @Override
    public boolean isAuthenticated(String secret) {
        return this.tokensBySecret.containsKey(secret) && this.tokensBySecret.get(secret).isAuthenticated();
    }
}

