/*
 * Decompiled with CFR 0.152.
 */
package notclive.security.email;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import notclive.security.email.EmailSecurityRequestMatcher;
import notclive.security.email.configuration.EmailSecurityProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

@Component
public class EmailSecuritySuccessHandler
implements AuthenticationSuccessHandler {
    private final EmailSecurityRequestMatcher requestMatcher;
    private final AuthenticationSuccessHandler emailReceivedSuccessHandler;
    private final AuthenticationSuccessHandler tokenReceivedSuccessHandler;

    @Autowired
    public EmailSecuritySuccessHandler(EmailSecurityProperties properties, EmailSecurityRequestMatcher requestMatcher) {
        this.requestMatcher = requestMatcher;
        String acknowledgment = properties.getPaths().getAcknowledgment();
        this.emailReceivedSuccessHandler = new SimpleUrlAuthenticationSuccessHandler(acknowledgment);
        this.tokenReceivedSuccessHandler = new SavedRequestAwareAuthenticationSuccessHandler();
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        if (this.requestMatcher.isProvidingEmailAddress(request)) {
            this.emailReceivedSuccessHandler.onAuthenticationSuccess(request, response, authentication);
        } else if (this.requestMatcher.isProvidingSecret(request)) {
            this.tokenReceivedSuccessHandler.onAuthenticationSuccess(request, response, authentication);
        }
    }
}

