/*
 * Decompiled with CFR 0.152.
 */
package notclive.security.email;

import javax.servlet.http.HttpServletRequest;
import notclive.security.email.EmailSecurityTokenRepository;
import notclive.security.email.configuration.EmailSecurityProperties;
import notclive.security.email.principals.EmailSecurityEmailKnownPrincipal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.stereotype.Component;

@Component
public class EmailSecurityRequestMatcher
implements RequestMatcher {
    @Autowired
    private EmailSecurityProperties properties;
    @Autowired
    private EmailSecurityTokenRepository tokenRepository;

    public boolean matches(HttpServletRequest request) {
        return this.isProvidingEmailAddress(request) || this.secretHasBeenProvidedInAnotherSession() || this.isProvidingSecret(request);
    }

    public boolean isProvidingEmailAddress(HttpServletRequest request) {
        return EmailSecurityRequestMatcher.getPath(request).equals(this.properties.getPaths().getForm()) && request.getMethod().equals(HttpMethod.POST.toString());
    }

    public boolean secretHasBeenProvidedInAnotherSession() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof EmailSecurityEmailKnownPrincipal) {
            String secret = (String)authentication.getCredentials();
            return this.tokenRepository.isAuthenticated(secret);
        }
        return false;
    }

    public boolean isProvidingSecret(HttpServletRequest request) {
        return EmailSecurityRequestMatcher.getPath(request).equals(this.properties.getPaths().getSecret());
    }

    private static String getPath(HttpServletRequest request) {
        return request.getRequestURI().substring(request.getContextPath().length());
    }
}

