/*
 * Decompiled with CFR 0.152.
 */
package notclive.security.email;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import notclive.security.email.EmailSecurityEmailSender;
import notclive.security.email.EmailSecurityRequestMatcher;
import notclive.security.email.EmailSecuritySuccessHandler;
import notclive.security.email.EmailSecurityToken;
import notclive.security.email.EmailSecurityTokenRepository;
import notclive.security.email.configuration.EmailSecurityProperties;
import notclive.security.email.exceptions.InvalidEmailAddressException;
import notclive.security.email.exceptions.UnknownSecretException;
import notclive.security.email.principals.EmailSecurityEmailKnownPrincipal;
import notclive.security.email.principals.EmailSecurityUserPrincipal;
import notclive.security.email.rememberMe.EmailSecurityRememberMeServices;
import org.hibernate.validator.internal.constraintvalidators.EmailValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.util.RedirectUrlBuilder;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.stereotype.Component;

@Component
public class EmailSecurityFilter
extends AbstractAuthenticationProcessingFilter {
    private final EmailValidator emailValidator = new EmailValidator();
    private final EmailSecurityProperties properties;
    private final EmailSecurityRequestMatcher requestMatcher;
    private final EmailSecurityTokenRepository tokenRepository;
    private final EmailSecurityEmailSender emailSender;
    private final EmailSecurityRememberMeServices rememberMeServices;

    @Autowired
    protected EmailSecurityFilter(EmailSecurityProperties properties, EmailSecurityRequestMatcher requestMatcher, EmailSecurityTokenRepository tokenRepository, EmailSecurityEmailSender emailSender, EmailSecurityRememberMeServices rememberMeServices) {
        super((RequestMatcher)requestMatcher);
        this.properties = properties;
        this.requestMatcher = requestMatcher;
        this.tokenRepository = tokenRepository;
        this.emailSender = emailSender;
        this.rememberMeServices = rememberMeServices;
    }

    @Autowired
    public void setAuthenticationSuccessHandler(EmailSecuritySuccessHandler successHandler) {
        super.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)successHandler);
    }

    @Autowired
    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        super.setAuthenticationManager(authenticationManager);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) {
        if (this.requestMatcher.isProvidingEmailAddress(request)) {
            return this.authenticateEmailAddress(request);
        }
        if (this.requestMatcher.secretHasBeenProvidedInAnotherSession()) {
            return this.authenticateUser(request, response);
        }
        if (this.requestMatcher.isProvidingSecret(request)) {
            return this.authenticateSecret(request);
        }
        return null;
    }

    private Authentication authenticateEmailAddress(HttpServletRequest request) {
        String emailAddress = this.getValidEmailAddress(request);
        boolean rememberMe = Boolean.parseBoolean(request.getParameter("remember-me"));
        String secret = this.generateSecret(emailAddress);
        this.tokenRepository.store(new EmailSecurityToken(emailAddress, secret, false));
        this.emailSender.send(emailAddress, this.generateSecretUrl(request, secret));
        return new EmailSecurityEmailKnownPrincipal(emailAddress, secret, rememberMe);
    }

    private String getValidEmailAddress(HttpServletRequest request) {
        String emailAddress = request.getParameter("email");
        if (this.emailValidator.isValid((CharSequence)emailAddress, null)) {
            return emailAddress;
        }
        throw new InvalidEmailAddressException();
    }

    private String generateSecret(String emailAddress) {
        return this.properties.getPredictableSecrets() ? emailAddress : UUID.randomUUID().toString();
    }

    private String generateSecretUrl(HttpServletRequest request, String secret) {
        RedirectUrlBuilder urlBuilder = new RedirectUrlBuilder();
        urlBuilder.setScheme(request.getScheme());
        urlBuilder.setServerName(request.getServerName());
        urlBuilder.setPort(request.getServerPort());
        urlBuilder.setContextPath(request.getContextPath());
        urlBuilder.setPathInfo(this.properties.getPaths().getSecret());
        urlBuilder.setQuery("secret=" + secret);
        return urlBuilder.getUrl();
    }

    private Authentication authenticateUser(HttpServletRequest request, HttpServletResponse response) {
        String emailAddress = (String)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        EmailSecurityUserPrincipal authentication = new EmailSecurityUserPrincipal(emailAddress);
        this.rememberMeServices.loginSuccess(request, response, (Authentication)authentication);
        return authentication;
    }

    private Authentication authenticateSecret(HttpServletRequest request) {
        String secret = request.getParameter("secret");
        EmailSecurityToken token = this.tokenRepository.authenticate(secret);
        if (token == null) {
            throw new UnknownSecretException();
        }
        return null;
    }
}

