/*
 * Decompiled with CFR 0.152.
 */
package notclive.security.email;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import notclive.security.email.configuration.EmailSecurityProperties;
import notclive.security.email.principals.EmailSecurityAuthorities;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.access.AccessDeniedHandlerImpl;
import org.springframework.stereotype.Component;

@Component
public class EmailSecurityAccessDeniedHandler
extends AccessDeniedHandlerImpl {
    private final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    @Autowired
    private EmailSecurityProperties properties;

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        if (this.emailIsKnown()) {
            this.redirectToAcknowledgmentPage(request, response);
        } else {
            super.handle(request, response, accessDeniedException);
        }
    }

    private boolean emailIsKnown() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication != null && authentication.getAuthorities().contains(EmailSecurityAuthorities.EMAIL_KNOWN);
    }

    private void redirectToAcknowledgmentPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String acknowledgmentPath = this.properties.getPaths().getAcknowledgment();
        this.redirectStrategy.sendRedirect(request, response, acknowledgmentPath);
    }
}

