package notclive.security.email.principals;

import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

import java.util.ArrayList;
import java.util.List;

import static notclive.security.email.principals.EmailSecurityAuthorities.EMAIL_KNOWN;

public class EmailSecurityEmailKnownPrincipal extends AbstractAuthenticationToken {

    private final String emailAddress;
    private final String secret;
    private final boolean rememberMe;

    public EmailSecurityEmailKnownPrincipal(String emailAddress, String secret, boolean rememberMe) {
        super(emailKnownAuthority());
        this.emailAddress = emailAddress;
        this.secret = secret;
        this.rememberMe = rememberMe;
    }

    private static List<SimpleGrantedAuthority> emailKnownAuthority() {
        List<SimpleGrantedAuthority> authorities = new ArrayList<>();
        authorities.add(EMAIL_KNOWN);
        return authorities;
    }

    @Override
    public Object getCredentials() {
        return secret;
    }

    @Override
    public Object getPrincipal() {
        return emailAddress;
    }

    public boolean getRememberMe() {
        return rememberMe;
    }
}
