package notclive.security.email;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

@Component
public class InMemoryEmailSecurityTokenRepository implements EmailSecurityTokenRepository {

    private final Map<String, EmailSecurityToken> tokensBySecret = new HashMap<>();

    @Override
    public void store(EmailSecurityToken token) {
        tokensBySecret.put(token.getSecret(), token);
    }

    @Override
    public EmailSecurityToken authenticate(String secret) {
        if (tokensBySecret.containsKey(secret)) {
            EmailSecurityToken token = tokensBySecret.get(secret);
            EmailSecurityToken authenticatedToken = new EmailSecurityToken(token.getEmailAddress(), secret, true);
            store(authenticatedToken);
            return authenticatedToken;
        }
        return null;
    }

    @Override
    public boolean isAuthenticated(String secret) {
        return tokensBySecret.containsKey(secret)
            && tokensBySecret.get(secret).isAuthenticated();
    }
}
