package notclive.security.email;

import java.util.Objects;

public class EmailSecurityToken {

    private final String emailAddress;
    private final String secret;
    private final boolean authenticated;

    public EmailSecurityToken(String emailAddress, String secret, boolean authenticated) {
        this.emailAddress = emailAddress;
        this.secret = secret;
        this.authenticated = authenticated;
    }

    public String getEmailAddress() {
        return emailAddress;
    }

    public String getSecret() {
        return secret;
    }

    public boolean isAuthenticated() {
        return authenticated;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) { return true; }
        if (o == null || getClass() != o.getClass()) { return false; }

        EmailSecurityToken that = (EmailSecurityToken) o;
        return Objects.equals(this.emailAddress, that.emailAddress)
            && Objects.equals(this.secret, that.secret)
            && Objects.equals(this.authenticated, that.authenticated);
    }

    @Override
    public int hashCode() {
        return Objects.hash(emailAddress, secret, authenticated);
    }
}
