package notclive.security.email;

import notclive.security.email.configuration.EmailSecurityProperties;
import notclive.security.email.principals.EmailSecurityEmailKnownPrincipal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;

@Component
public class EmailSecurityRequestMatcher implements RequestMatcher {

    @Autowired
    private EmailSecurityProperties properties;

    @Autowired
    private EmailSecurityTokenRepository tokenRepository;

    @Override
    public boolean matches(HttpServletRequest request) {
        return isProvidingEmailAddress(request)
            || secretHasBeenProvidedInAnotherSession()
            || isProvidingSecret(request);
    }

    public boolean isProvidingEmailAddress(HttpServletRequest request) {
        return getPath(request).equals(properties.getPaths().getForm())
            && request.getMethod().equals(HttpMethod.POST.toString());
    }

    public boolean secretHasBeenProvidedInAnotherSession() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof EmailSecurityEmailKnownPrincipal) {
            String secret = (String) authentication.getCredentials();
            return tokenRepository.isAuthenticated(secret);
        }
        return false;
    }

    public boolean isProvidingSecret(HttpServletRequest request) {
        return getPath(request).equals(properties.getPaths().getSecret());
    }

    private static String getPath(HttpServletRequest request) {
        return request.getRequestURI().substring(request.getContextPath().length());
    }
}
