package notclive.security.email.principals;

import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

import java.util.ArrayList;
import java.util.List;

import static notclive.security.email.principals.EmailSecurityAuthorities.USER;

public class EmailSecurityUserPrincipal extends AbstractAuthenticationToken {

    private final String emailAddress;

    public EmailSecurityUserPrincipal(String emailAddress) {
        super(userAuthority());
        this.emailAddress = emailAddress;
    }

    private static List<SimpleGrantedAuthority> userAuthority() {
        List<SimpleGrantedAuthority> authorities = new ArrayList<>();
        authorities.add(USER);
        return authorities;
    }

    @Override
    public Object getCredentials() {
        return null;
    }

    @Override
    public Object getPrincipal() {
        return emailAddress;
    }
}
