package notclive.security.email.configuration;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.UUID;

@Component
@ConfigurationProperties(prefix = "email-security", ignoreUnknownFields = false)
public class EmailSecurityProperties {

    private Paths paths = new Paths();

    private String rememberMeSecret = UUID.randomUUID().toString();

    private boolean predictableSecrets = false;

    public Paths getPaths() {
        return paths;
    }

    public void setPaths(Paths paths) {
        this.paths = paths;
    }

    public String getRememberMeSecret() {
        return rememberMeSecret;
    }

    /**
     * Must be set to a constant value for remember-me cookies to work between application restarts.
     */
    public void setRememberMeSecret(String rememberMeSecret) {
        this.rememberMeSecret = rememberMeSecret;
    }

    public boolean getPredictableSecrets() {
        return predictableSecrets;
    }

    /**
     * Should only be used for testing purposes.
     * Sets the secret email to the user to be the same as the provided email address.
     */
    public void setPredictableSecrets(boolean predictableSecrets) {
        this.predictableSecrets = predictableSecrets;
    }

    public static class Paths {

        private String form = "/auth/form";
        private String acknowledgment = "/auth/email-sent";
        private String secret = "/auth/secret";

        public String getForm() {
            return form;
        }

        public void setForm(String form) {
            this.form = form;
        }

        public String getAcknowledgment() {
            return acknowledgment;
        }

        public void setAcknowledgment(String acknowledgment) {
            this.acknowledgment = acknowledgment;
        }

        public String getSecret() {
            return secret;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }
    }
}
