package notclive.security.email.configuration;

import notclive.security.email.EmailSecurityAccessDeniedHandler;
import notclive.security.email.EmailSecurityFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationFilter;

import static notclive.security.email.principals.EmailSecurityAuthorities.USER_ROLE;

@Configuration
public class EmailSecurityConfigurerAdapter extends WebSecurityConfigurerAdapter {

    @Autowired
    private EmailSecurityProperties properties;

    @Autowired
    private EmailSecurityFilter filter;

    @Autowired
    private EmailSecurityAccessDeniedHandler accessDeniedHandler;

    @Autowired
    private RememberMeAuthenticationFilter rememberMeAuthenticationFilter;

    @Override
    protected void configure(HttpSecurity http) throws Exception {
        http.authorizeRequests()
                .antMatchers(properties.getPaths().getForm()).permitAll()
                .anyRequest().hasAuthority(USER_ROLE)
            .and()
            .exceptionHandling()
                .authenticationEntryPoint(entryPointFor(properties.getPaths().getForm()))
                .accessDeniedHandler(accessDeniedHandler)
            .and()
            .addFilterBefore(filter, UsernamePasswordAuthenticationFilter.class)
            .addFilter(rememberMeAuthenticationFilter);
    }

    private LoginUrlAuthenticationEntryPoint entryPointFor(String path) {
        return new LoginUrlAuthenticationEntryPoint(path);
    }
}
