package notclive.security.email.configuration;

import notclive.security.email.rememberMe.EmailSecurityRememberMeServices;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationFilter;

import java.time.Clock;

@Configuration
@ComponentScan("notclive.security.email")
@EnableWebSecurity // Disable SecurityAutoConfiguration from spring-boot-autoconfigure
@EnableConfigurationProperties
public class EmailSecurityConfiguration {

    @Bean
    public RememberMeAuthenticationFilter rememberMeAuthenticationFilter(AuthenticationManager authenticationManager,
                                                                         EmailSecurityRememberMeServices rememberMeServices) {
        return new RememberMeAuthenticationFilter(authenticationManager, rememberMeServices);
    }

    @Bean
    @ConditionalOnMissingBean(Clock.class)
    public Clock clock() {
        return Clock.systemDefaultZone();
    }
}