package notclive.security.email;

/**
 * We require the token repository to share log in attempts accross sessions.
 * The user might not be request authentication and provide the secret using the same session.
 * For example the user might try and log in on a desktop, and use a mobile device to provide the secret.
 **/
public interface EmailSecurityTokenRepository {

    void store(EmailSecurityToken token);

    EmailSecurityToken authenticate(String secret);

    boolean isAuthenticated(String secret);
}
