package notclive.security.email;

import notclive.security.email.configuration.EmailSecurityProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@Component
public class EmailSecuritySuccessHandler implements AuthenticationSuccessHandler {

    private final EmailSecurityRequestMatcher requestMatcher;
    private final AuthenticationSuccessHandler emailReceivedSuccessHandler;
    private final AuthenticationSuccessHandler tokenReceivedSuccessHandler;

    @Autowired
    public EmailSecuritySuccessHandler(EmailSecurityProperties properties,
                                       EmailSecurityRequestMatcher requestMatcher) {
        this.requestMatcher = requestMatcher;
        String acknowledgment = properties.getPaths().getAcknowledgment();
        emailReceivedSuccessHandler = new SimpleUrlAuthenticationSuccessHandler(acknowledgment);
        tokenReceivedSuccessHandler = new SavedRequestAwareAuthenticationSuccessHandler();
    }

    @Override
    public void onAuthenticationSuccess(HttpServletRequest request,
                                        HttpServletResponse response,
                                        Authentication authentication)
            throws IOException, ServletException {
        if (requestMatcher.isProvidingEmailAddress(request)) {
            emailReceivedSuccessHandler.onAuthenticationSuccess(request, response, authentication);
        } else if (requestMatcher.isProvidingSecret(request)) {
            tokenReceivedSuccessHandler.onAuthenticationSuccess(request, response, authentication);
        }
    }
}
