/*
 * Decompiled with CFR 0.152.
 */
package nginx.clojure.jersey;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import nginx.clojure.MiniConstants;
import nginx.clojure.NginxClojureRT;
import nginx.clojure.NginxHttpServerChannel;
import nginx.clojure.bridge.NginxBridge;
import nginx.clojure.java.NginxJavaRequest;
import org.glassfish.jersey.internal.MapPropertiesDelegate;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;

public class NginxJerseyContainer
implements NginxBridge {
    protected ApplicationHandler appHandler;
    protected String appPath;
    protected Class[] appResources;
    protected ClassLoader bootLoader;

    protected ResourceConfig configure() {
        return new ResourceConfig(this.appResources);
    }

    public void boot(Map<String, String> properties, ClassLoader loader) {
        this.appPath = properties.get("jersey.app.path");
        this.bootLoader = loader;
        if (this.appPath == null) {
            this.appPath = "";
        }
        String res = properties.get("jersey.app.resources");
        ArrayList clzList = new ArrayList();
        if (res != null) {
            for (String clz : res.split(",")) {
                try {
                    clzList.add(loader.loadClass(clz.trim()));
                }
                catch (Throwable e) {
                    NginxClojureRT.log.warn("can not load resource %s, skiping", new Object[]{clz, e});
                }
            }
            this.appResources = clzList.toArray(new Class[clzList.size()]);
        }
        if (this.appResources == null || this.appResources.length == 0) {
            NginxClojureRT.log.warn("no resource defined, property %s is null", new Object[]{"jersey.app.resources"});
        }
        this.appHandler = new ApplicationHandler((Application)this.configure());
    }

    public ClassLoader getClassLoader() {
        return this.bootLoader;
    }

    protected SecurityContext getSecurityContext(final Principal principal, final boolean isSecure) {
        return new SecurityContext(){

            public boolean isUserInRole(String role) {
                return false;
            }

            public boolean isSecure() {
                return isSecure;
            }

            public Principal getUserPrincipal() {
                return principal;
            }

            public String getAuthenticationScheme() {
                return null;
            }
        };
    }

    public Object[] handle(NginxJavaRequest req) throws IOException {
        URI baseUri;
        NginxHttpServerChannel sc = req.hijack(false);
        Map headers = (Map)req.get((Object)"headers");
        try {
            baseUri = new URI((String)req.get((Object)"scheme") + "://" + headers.get("host") + this.appPath + (this.appPath.endsWith("/") ? "" : "/"));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        URI requestUri = baseUri.resolve(req.getVariable("request_uri"));
        ContainerRequest cr = new ContainerRequest(baseUri, requestUri, ((String)req.get((Object)"request-method")).toUpperCase(), this.getSecurityContext(null, false), (PropertiesDelegate)new MapPropertiesDelegate());
        cr.setEntityStream((InputStream)req.get((Object)"body"));
        MultivaluedMap crHeaders = cr.getHeaders();
        for (Map.Entry en : headers.entrySet()) {
            Object v = en.getValue();
            if (v == null) continue;
            if (v.getClass().isArray()) {
                crHeaders.put(en.getKey(), Arrays.asList((String[])v));
                continue;
            }
            crHeaders.putSingle(en.getKey(), (Object)((String)v));
        }
        NginxReponseWriter writer = new NginxReponseWriter(sc);
        cr.setWriter((ContainerResponseWriter)writer);
        this.appHandler.handle(cr);
        if (!writer.suspend) {
            sc.close();
        }
        return null;
    }

    public static class NginxReponseWriter
    implements ContainerResponseWriter {
        protected boolean suspend = false;
        protected NginxHttpServerChannel sc;

        public NginxReponseWriter() {
        }

        public NginxReponseWriter(NginxHttpServerChannel sc) {
            this.sc = sc;
        }

        public void commit() {
            try {
                this.sc.close();
            }
            catch (IOException e) {
                NginxClojureRT.log.error((Object)"commit failure!", (Throwable)e);
            }
        }

        public boolean enableResponseBuffering() {
            return true;
        }

        public void failure(Throwable e) {
            NginxClojureRT.log.error((Object)"failure from jersey", e);
            try {
                this.sc.sendResponse(MiniConstants.NGX_HTTP_INTERNAL_SERVER_ERROR);
            }
            catch (IOException e1) {
                NginxClojureRT.log.error((Object)"send error response failed!", e);
            }
        }

        public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
        }

        public boolean suspend(long timeOut, TimeUnit timeUnit, ContainerResponseWriter.TimeoutHandler timeoutHandler) {
            this.suspend = true;
            return true;
        }

        public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse context) throws ContainerException {
            try {
                this.sc.sendHeader((long)context.getStatus(), (Collection)context.getStringHeaders().entrySet(), true, false);
            }
            catch (IOException e) {
                throw new ContainerException("send header error!", (Throwable)e);
            }
            return new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    this.write(new byte[]{(byte)b}, 0, 1);
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    if (b == null) {
                        throw new NullPointerException("byte[] can not be null");
                    }
                    if (off + len > b.length) {
                        throw new IndexOutOfBoundsException("buffer space is too small, off + len > b.length");
                    }
                    NginxReponseWriter.this.sc.send(b, off, len, false, false);
                }

                @Override
                public void flush() throws IOException {
                    NginxReponseWriter.this.sc.flush();
                }

                @Override
                public void close() throws IOException {
                    NginxReponseWriter.this.sc.close();
                }
            };
        }
    }
}

