/*
 * Decompiled with CFR 0.152.
 */
package nexcore.sprout.spring.boot.autoconfigure.webmvc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import nexcore.sprout.foundry.webmvc.filter.GuidGenerateServletFilter;
import nexcore.sprout.foundry.webmvc.filter.MDCInsertingServletFilter;
import nexcore.sprout.spring.boot.autoconfigure.webmvc.SproutWebMvcProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.OrderComparator;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;
import org.springframework.web.servlet.view.BeanNameViewResolver;
import org.springframework.web.servlet.view.ContentNegotiatingViewResolver;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

@Configuration
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={SproutWebMvcProperties.class})
public class SproutWebMvcAutoConfiguration
extends WebMvcConfigurerAdapter
implements ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(SproutWebMvcAutoConfiguration.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private SproutWebMvcProperties sproutWebMvcProperties;

    @Bean
    @ConditionalOnMissingBean
    public FilterRegistrationBean guidGenerateServletFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new GuidGenerateServletFilter());
        registration.setOrder(2147483627);
        registration.setName("guidGenerateServletFilter");
        registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[0]);
        return registration;
    }

    @Bean
    public FilterRegistrationBean MDCInsertingServletFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new MDCInsertingServletFilter());
        registration.setOrder(0x7FFFFFF5);
        registration.setName("MDCInsertingServletFilter");
        registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[0]);
        return registration;
    }

    @Bean
    @ConditionalOnMissingBean
    public LocaleResolver localeResolver() {
        SessionLocaleResolver sessionLocaleResolver = new SessionLocaleResolver();
        if (this.sproutWebMvcProperties.getDefaultLocale() != null) {
            sessionLocaleResolver.setDefaultLocale(this.sproutWebMvcProperties.getDefaultLocale());
        }
        logger.info((Object)("====== Creating Locale Resolver: " + sessionLocaleResolver.getClass().toString()));
        logger.info((Object)("====== Default Locale: " + this.sproutWebMvcProperties.getDefaultLocale().toString()));
        return sessionLocaleResolver;
    }

    @Bean
    @ConditionalOnMissingBean
    public LocaleChangeInterceptor localeChangeInterceptor() {
        LocaleChangeInterceptor localeChangeInterceptor = new LocaleChangeInterceptor();
        if (this.sproutWebMvcProperties.getLocaleParamName() != null) {
            localeChangeInterceptor.setParamName(this.sproutWebMvcProperties.getLocaleParamName());
        }
        logger.info((Object)("====== Creating LocaleChangeInterceptor: " + localeChangeInterceptor.getClass().toString()));
        logger.info((Object)("====== LocaleChangeInterceptor for ParamName: " + this.sproutWebMvcProperties.getLocaleParamName().toString()));
        return localeChangeInterceptor;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.applicationContext.getBean(LocaleChangeInterceptor.class));
        logger.info((Object)"====== Add Interceptor localeChangeInterceptor");
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        List<SproutWebMvcProperties.View> viewList = this.sproutWebMvcProperties.getView();
        try {
            for (SproutWebMvcProperties.View view : viewList) {
                registry.addViewController(view.getViewController()).setViewName(view.getViewName());
            }
        }
        catch (Exception e) {
            logger.info((Object)"No View Controller");
        }
    }

    @Bean
    @ConditionalOnBean(value={View.class})
    public BeanNameViewResolver beanNameViewResolver() {
        BeanNameViewResolver resolver = new BeanNameViewResolver();
        resolver.setOrder(Integer.MIN_VALUE);
        logger.info((Object)("====== Creating Resolver: " + resolver.getClass().toString()));
        return resolver;
    }

    @Bean(name={"viewResolver"})
    @ConditionalOnBean(value={ViewResolver.class})
    public ContentNegotiatingViewResolver viewResolver(BeanFactory beanFactory) {
        ContentNegotiatingViewResolver resolver = new ContentNegotiatingViewResolver();
        resolver.setContentNegotiationManager((ContentNegotiationManager)beanFactory.getBean(ContentNegotiationManager.class));
        Map viewResolvers = this.applicationContext.getBeansOfType(InternalResourceViewResolver.class);
        ArrayList viewResolverList = new ArrayList(viewResolvers.values());
        OrderComparator.sort(viewResolverList);
        resolver.setViewResolvers(viewResolverList);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"====== ViewResolver List in ContentNegotiatingViewResolver ======");
            for (ViewResolver viewResolver : viewResolverList) {
                logger.debug((Object)("ViewResolver: " + viewResolver.getClass()));
            }
            logger.debug((Object)"=================================================================");
        }
        ArrayList<MappingJackson2JsonView> defaultViewList = new ArrayList<MappingJackson2JsonView>();
        defaultViewList.add(new MappingJackson2JsonView());
        resolver.setDefaultViews(defaultViewList);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"====== DefaultView List in ContentNegotiatingViewResolver ======");
            for (View view : defaultViewList) {
                logger.debug((Object)("Default View: " + view.getClass()));
            }
            logger.debug((Object)"================================================================");
        }
        resolver.setOrder(-2147483638);
        return resolver;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.applicationContext = (ConfigurableApplicationContext)applicationContext;
        }
    }
}

