/*
 * Decompiled with CFR 0.152.
 */
package nexcore.sprout.spring.boot.autoconfigure.webmvc;

import nexcore.sprout.foundry.webmvc.interceptors.CommonFieldSetter;
import nexcore.sprout.spring.boot.autoconfigure.webmvc.CommonFieldSetterProperties;
import nexcore.sprout.spring.boot.autoconfigure.webmvc.SproutWebMvcAutoConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ConditionalOnProperty(prefix="sprout.mvc.common-field-setter", name={"enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureAfter(value={SproutWebMvcAutoConfiguration.class})
@ConditionalOnWebApplication
@AutoConfigureOrder(value=2147483627)
@EnableConfigurationProperties(value={CommonFieldSetterProperties.class})
public class CommonFieldSetterAutoConfiguration
extends WebMvcConfigurerAdapter {
    private static final Log logger = LogFactory.getLog(CommonFieldSetterAutoConfiguration.class);
    @Autowired
    CommonFieldSetterProperties commonFieldSetterProperties;

    @Bean
    @ConditionalOnMissingBean
    public CommonFieldSetter commonFieldSetter() {
        CommonFieldSetter commonFieldSetter = new CommonFieldSetter();
        logger.info((Object)("====== Creating Bean: " + commonFieldSetter.getClass().toString()));
        if (this.commonFieldSetterProperties.getResultCodeFieldKeyName() != null) {
            commonFieldSetter.setResultCodeFieldKeyName(this.commonFieldSetterProperties.getResultCodeFieldKeyName());
        }
        if (this.commonFieldSetterProperties.getResultMessageFieldKeyName() != null) {
            commonFieldSetter.setResultMessageFieldKeyName(this.commonFieldSetterProperties.getResultMessageFieldKeyName());
        }
        if (this.commonFieldSetterProperties.getSuccessResultCode() != null) {
            commonFieldSetter.setSuccessResultCode(this.commonFieldSetterProperties.getSuccessResultCode());
        }
        if (!this.commonFieldSetterProperties.isSupportOildVersion()) {
            commonFieldSetter.setSupportOildVersion(this.commonFieldSetterProperties.isSupportOildVersion());
        }
        logger.info((Object)("====== ResultCodeFieldKeyName : " + commonFieldSetter.getResultCodeFieldKeyName()));
        logger.info((Object)("====== ResultMessageFieldKeyName : " + commonFieldSetter.getResultMessageFieldKeyName()));
        logger.info((Object)("====== SuccessResultCode : " + commonFieldSetter.getSuccessResultCode()));
        logger.info((Object)("====== SupportOildVersion : " + commonFieldSetter.isSupportOildVersion()));
        return commonFieldSetter;
    }

    @ConditionalOnBean(value={CommonFieldSetter.class})
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.commonFieldSetter()).addPathPatterns(this.commonFieldSetterProperties.getPathPatterns()).excludePathPatterns(this.commonFieldSetterProperties.getExcludePatterns());
        logger.info((Object)"====== Add Interceptor commonFieldSetter");
    }
}

