/*
 * Decompiled with CFR 0.152.
 */
package nexcore.sprout.spring.boot.autoconfigure.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.session.ExpiringSession;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;

public class RedisSessionRegistry
implements SessionRegistry {
    private static final Log logger = LogFactory.getLog(RedisSessionRegistry.class);
    private final SessionRepository<ExpiringSession> sessionRepository;
    private static final String SPRING_SECURITY_CONTEXT = "SPRING_SECURITY_CONTEXT";
    @Autowired
    private ApplicationContext applicationContext;

    @Autowired
    public RedisSessionRegistry(FindByIndexNameSessionRepository<ExpiringSession> sessionRepository) {
        this.sessionRepository = sessionRepository;
    }

    public List<SessionInformation> getAllSessions(Object principal, boolean includeExpiredSessions) {
        Collection indexValue = ((FindByIndexNameSessionRepository)this.sessionRepository).findByIndexNameAndIndexValue(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME, this.getUserId(principal)).values();
        ArrayList<SessionInformation> sessionlist = new ArrayList<SessionInformation>();
        for (ExpiringSession sessionValue : indexValue) {
            SessionInformation sessionInformation = new SessionInformation(RedisSessionRegistry.getPrincipal((Session)sessionValue), sessionValue.getId(), new Date(sessionValue.getLastAccessedTime()));
            if (!includeExpiredSessions && sessionInformation.isExpired()) continue;
            sessionlist.add(sessionInformation);
        }
        return sessionlist;
    }

    public SessionInformation getSessionInformation(String sessionId) {
        ExpiringSession session = (ExpiringSession)this.sessionRepository.getSession(sessionId);
        if (session != null) {
            return new SessionInformation(RedisSessionRegistry.getPrincipal((Session)session), session.getId(), new Date(session.getLastAccessedTime()));
        }
        return null;
    }

    private static Object getPrincipal(Session session) {
        String principalName = (String)session.getAttribute(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME);
        if (principalName != null) {
            return principalName;
        }
        SecurityContext securityContext = (SecurityContext)session.getAttribute(SPRING_SECURITY_CONTEXT);
        if (securityContext != null && securityContext.getAuthentication() != null) {
            return securityContext.getAuthentication().getName();
        }
        return "";
    }

    private String getUserId(Object principal) {
        String userId = "";
        if (principal instanceof UserDetails) {
            userId = ((UserDetails)principal).getUsername();
        }
        return userId;
    }

    public List<Object> getAllPrincipals() {
        throw new UnsupportedOperationException();
    }

    public void refreshLastRequest(String sessionId) {
        ExpiringSession session = (ExpiringSession)this.sessionRepository.getSession(sessionId);
        session.setLastAccessedTime(System.currentTimeMillis());
        this.sessionRepository.save((Session)session);
    }

    public void registerNewSession(String sessionId, Object principal) {
    }

    public void removeSessionInformation(String sessionId) {
        this.sessionRepository.delete(sessionId);
    }
}

